/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.controller;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.resources.WorkFileSettings;
import com.mayastudios.fred.client.view.CMainWindow;
import com.mayastudios.fred.client.view.ContextMenuProvider;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import net.mayastudios.mscl.mwt.trayicon.CTrayIcon;
import net.mayastudios.mscl.mwt.trayicon.TrayIconInfo;
import net.mayastudios.mscl.mwt.trayicon.TrayMinimizeHelper;

public class TrayIconController {
    private static volatile boolean isInIncommingExit;

    public static void init() {
        if (!TrayIconInfo.isTrayIconAvailable()) {
            return;
        }
        CTrayIconListener cTrayIconListener = new CTrayIconListener();
        CTrayIcon cTrayIcon = new CTrayIcon((Icon)CMainWindow.MAIN_ICON, "Fred 2009");
        MainController.getInstance().getMainWindow().addWindowListener(cTrayIconListener);
        cTrayIcon.setClickListener((CTrayIcon.ITrayIconClickListener)cTrayIconListener);
        cTrayIcon.setPopupMenu((JPopupMenu)((Object)ContextMenuProvider.provideTrayIconMenu()));
        isInIncommingExit = false;
        cTrayIcon.setVisible(true);
    }

    public static void incomingToggleVisibility() {
        CMainWindow cMainWindow = MainController.getInstance().getMainWindow();
        int n = cMainWindow.getExtendedState();
        if (!cMainWindow.isVisible() || (n & 1) != 0) {
            TrayMinimizeHelper.restoreFrame((Frame)cMainWindow);
        } else {
            TrayMinimizeHelper.minimizeToTray((Frame)cMainWindow);
        }
    }

    public static void incomingExit() {
        if (isInIncommingExit) {
            MainController.getInstance().getMainWindow().setVisible(true);
        } else {
            isInIncommingExit = true;
            MainController.incomingFileExit();
            isInIncommingExit = false;
        }
    }

    private static class CTrayIconListener
    extends WindowAdapter
    implements CTrayIcon.ITrayIconClickListener {
        @Override
        public void windowIconified(WindowEvent windowEvent) {
            if (MainController.getInstance().getContent() != CMainWindow.EWindowContent.Views) {
                return;
            }
            if (WorkFileSettings.getAsBoolean(WorkFileSettings.EConf.MinimizeToTray)) {
                TrayMinimizeHelper.minimizeToTray((Frame)MainController.getInstance().getMainWindow());
            }
        }

        public void clickPerformed(CTrayIcon.CTrayIconClickEvent cTrayIconClickEvent) {
            if (cTrayIconClickEvent.mf_bIsDoubleClick) {
                TrayIconController.incomingToggleVisibility();
            } else {
                MainController.getInstance().getMainWindow().toFront();
            }
        }
    }
}

