/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.filehandling;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.exceptions.CXMLException;
import com.mayastudios.fred.client.filehandling.objectcontainer.AChildlessRootXMLObjectContainer;
import com.mayastudios.fred.client.filehandling.xml.XMLFileHandling;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.xml.sax.Attributes;

public class CSSTemplate {
    private static final String XML_PATH = "cfg/TemplateCSS.xml";
    private static final String XML_SCHEMA_PATH = "schemas/TemplateCSS.xsd";
    private static final String XML_TAG_NAME = "template";
    private static final String HTML_TAG = "style";
    private static final String HTML_ATTRIBUTES = "type=\"text/css\"";
    private static String s_strCSSTemplate = null;

    public static String getTemplate() {
        if (s_strCSSTemplate == null) {
            CSSTemplate.initializeTemplate();
        }
        return s_strCSSTemplate;
    }

    private static void initializeTemplate() {
        InputStream inputStream = MainController.getResLoader().getResourceStream(XML_PATH);
        URL uRL = MainController.getResLoader().getResourceUrl(XML_SCHEMA_PATH);
        CTemplateContainer cTemplateContainer = new CTemplateContainer();
        try {
            XMLFileHandling.processXML(XML_PATH, inputStream, uRL, cTemplateContainer.getHandler());
            s_strCSSTemplate = (String)cTemplateContainer.getContainedObject();
        }
        catch (IOException iOException) {
            throw new ExceptionInInitializerError(iOException);
        }
        catch (CXMLException cXMLException) {
            throw new ExceptionInInitializerError(cXMLException);
        }
    }

    private static class CTemplateContainer
    extends AChildlessRootXMLObjectContainer<String> {
        CTemplateContainer() {
            super(CSSTemplate.XML_TAG_NAME, 0);
        }

        @Override
        protected String createContainedObject(Attributes attributes, int n) {
            return String.format("<%s %s>\n<!--", CSSTemplate.HTML_TAG, CSSTemplate.HTML_ATTRIBUTES);
        }

        @Override
        protected void foundCharacters(String string, int n) {
            this.m_oObject = String.format("%s%s", this.m_oObject, string);
        }

        @Override
        protected void completeContainedObject(int n) {
            this.m_oObject = String.format("%s-->\n</%s>", this.m_oObject, CSSTemplate.HTML_TAG);
        }
    }
}

