/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.model;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.filehandling.objectcontainer.AChildlessXMLObjectContainer;
import com.mayastudios.fred.client.filehandling.objectcontainer.AXMLObjectContainer;
import com.mayastudios.fred.client.filehandling.xml.CSimpleXMLStream;
import com.mayastudios.fred.client.filehandling.xml.IXMLizable;
import com.mayastudios.fred.client.model.AReplicateableObjectImpl;
import com.mayastudios.fred.client.model.CEffortImpl;
import com.mayastudios.fred.client.model.CPersonImpl;
import com.mayastudios.fred.client.model.CProjectImpl;
import com.mayastudios.fred.client.model.CStatistic;
import com.mayastudios.fred.client.model.CTaskImpl;
import com.mayastudios.fred.client.model.ProjectList;
import com.mayastudios.fred.client.servertuning.IObjectFactoryEx;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultListModel;
import org.xml.sax.Attributes;

public class ObjectFactoryImpl
implements IObjectFactoryEx,
IXMLizable {
    public static final String XML_TAG_NAME = "objectfactory";
    public static final String XML_PERSONLIST_TAG_NAME = "personlist";
    private static final String XML_ATT_PROJECT_COUNT = "projectcount";
    private static final String XML_ATT_TASK_COUNT = "taskcount";
    private static final String XML_ATT_EFFORT_COUNT = "effortcount";
    private static final String XML_ATT_PERSON_COUNT = "personcount";
    private static ObjectFactoryImpl s_oInstance = null;
    private final HashMap<String, CProjectImpl> mf_oProjectMap;
    private final HashMap<String, CTaskImpl> mf_oTaskMap;
    private final HashMap<String, CEffortImpl> mf_oEffortMap;
    private final HashMap<String, CPersonImpl> mf_oPersonMap;

    private ObjectFactoryImpl(int n, int n2, int n3, int n4) {
        n = (int)((float)(Math.max(n, 5) + 2) / 0.7f);
        this.mf_oProjectMap = new HashMap(n, 0.7f);
        n2 = (int)((float)(Math.max(n2, 15) + n + 2) / 0.7f);
        this.mf_oTaskMap = new HashMap(n2, 0.7f);
        n3 = (int)((float)(Math.max(n3, 100) + n2 * 3 + 10) / 0.7f);
        this.mf_oEffortMap = new HashMap(n3, 0.7f);
        n4 = (int)((float)(Math.max(n4, 5) + n + 2) / 0.7f);
        this.mf_oPersonMap = new HashMap(n4, 0.7f);
    }

    public static void createInstance() {
        ObjectFactoryImpl.createInstance(5, 15, 100, 5);
    }

    public static void createInstance(int n, int n2, int n3, int n4) {
        if (s_oInstance != null) {
            throw new IllegalStateException("ObjectFactory was alredy created.");
        }
        s_oInstance = new ObjectFactoryImpl(n, n2, n3, n4);
    }

    public static ObjectFactoryImpl getInstance() {
        return s_oInstance;
    }

    public static void destroyInstance() {
        s_oInstance = null;
        System.gc();
    }

    @Override
    public CProjectImpl createProject(String string) {
        return ObjectFactoryImpl.createProjectImpl(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CProjectImpl createProjectImpl(String string) {
        HashMap<String, CProjectImpl> hashMap = ObjectFactoryImpl.s_oInstance.mf_oProjectMap;
        synchronized (hashMap) {
            CProjectImpl cProjectImpl = ObjectFactoryImpl.s_oInstance.mf_oProjectMap.get(string);
            if (cProjectImpl == null) {
                cProjectImpl = new CProjectImpl(string);
                ObjectFactoryImpl.s_oInstance.mf_oProjectMap.put(string, cProjectImpl);
            }
            return cProjectImpl;
        }
    }

    @Override
    public CTaskImpl createTask(String string) {
        return ObjectFactoryImpl.createTaskImpl(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CTaskImpl createTaskImpl(String string) {
        HashMap<String, CTaskImpl> hashMap = ObjectFactoryImpl.s_oInstance.mf_oTaskMap;
        synchronized (hashMap) {
            CTaskImpl cTaskImpl = ObjectFactoryImpl.s_oInstance.mf_oTaskMap.get(string);
            if (cTaskImpl == null) {
                cTaskImpl = new CTaskImpl(string);
                ObjectFactoryImpl.s_oInstance.mf_oTaskMap.put(string, cTaskImpl);
            }
            return cTaskImpl;
        }
    }

    @Override
    public CEffortImpl createEffort(String string) {
        return ObjectFactoryImpl.createEffortImpl(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CEffortImpl createEffortImpl(String string) {
        HashMap<String, CEffortImpl> hashMap = ObjectFactoryImpl.s_oInstance.mf_oEffortMap;
        synchronized (hashMap) {
            CEffortImpl cEffortImpl = ObjectFactoryImpl.s_oInstance.mf_oEffortMap.get(string);
            if (cEffortImpl == null) {
                cEffortImpl = new CEffortImpl(string);
                ObjectFactoryImpl.s_oInstance.mf_oEffortMap.put(string, cEffortImpl);
            }
            return cEffortImpl;
        }
    }

    @Override
    public CPersonImpl createPerson(String string) {
        return ObjectFactoryImpl.createPersonImpl(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CPersonImpl createPersonImpl(String string) {
        HashMap<String, CPersonImpl> hashMap = ObjectFactoryImpl.s_oInstance.mf_oPersonMap;
        synchronized (hashMap) {
            CPersonImpl cPersonImpl = ObjectFactoryImpl.s_oInstance.mf_oPersonMap.get(string);
            if (cPersonImpl == null) {
                cPersonImpl = new CPersonImpl(string);
                ObjectFactoryImpl.s_oInstance.mf_oPersonMap.put(string, cPersonImpl);
                MainController.getInstance().notifyControllers(MainController.EUpdateMessage.PersonsAdded, Collections.singleton(cPersonImpl));
            }
            return cPersonImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CProjectImpl findProject(String string) {
        HashMap<String, CProjectImpl> hashMap = ObjectFactoryImpl.s_oInstance.mf_oProjectMap;
        synchronized (hashMap) {
            return ObjectFactoryImpl.s_oInstance.mf_oProjectMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CTaskImpl findTask(String string) {
        HashMap<String, CTaskImpl> hashMap = ObjectFactoryImpl.s_oInstance.mf_oTaskMap;
        synchronized (hashMap) {
            return ObjectFactoryImpl.s_oInstance.mf_oTaskMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CEffortImpl findEffort(String string) {
        HashMap<String, CEffortImpl> hashMap = ObjectFactoryImpl.s_oInstance.mf_oEffortMap;
        synchronized (hashMap) {
            return ObjectFactoryImpl.s_oInstance.mf_oEffortMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CPersonImpl findPerson(String string) {
        HashMap<String, CPersonImpl> hashMap = ObjectFactoryImpl.s_oInstance.mf_oPersonMap;
        synchronized (hashMap) {
            return ObjectFactoryImpl.s_oInstance.mf_oPersonMap.get(string);
        }
    }

    public static Collection<CPersonImpl> getPersonList() {
        return Collections.unmodifiableCollection(ObjectFactoryImpl.s_oInstance.mf_oPersonMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultListModel getPersonsListModel() {
        DefaultListModel<CPersonImpl> defaultListModel = new DefaultListModel<CPersonImpl>();
        HashMap<String, CPersonImpl> hashMap = ObjectFactoryImpl.s_oInstance.mf_oPersonMap;
        synchronized (hashMap) {
            Iterator<CPersonImpl> iterator = ObjectFactoryImpl.s_oInstance.mf_oPersonMap.values().iterator();
            while (iterator.hasNext()) {
                defaultListModel.addElement(iterator.next());
            }
            return defaultListModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy(AReplicateableObjectImpl aReplicateableObjectImpl) {
        String string = aReplicateableObjectImpl.getID();
        if (aReplicateableObjectImpl instanceof CProjectImpl) {
            Object object = ObjectFactoryImpl.s_oInstance.mf_oProjectMap;
            synchronized (object) {
                ObjectFactoryImpl.s_oInstance.mf_oProjectMap.remove(string);
            }
            object = (CProjectImpl)aReplicateableObjectImpl;
            Iterator<CTaskImpl> iterator = ((CProjectImpl)object).getTaskIterator();
            while (iterator.hasNext()) {
                ObjectFactoryImpl.destroy(iterator.next());
            }
        } else if (aReplicateableObjectImpl instanceof CTaskImpl) {
            Object object = ObjectFactoryImpl.s_oInstance.mf_oTaskMap;
            synchronized (object) {
                ObjectFactoryImpl.s_oInstance.mf_oTaskMap.remove(string);
            }
            object = (CTaskImpl)aReplicateableObjectImpl;
            Iterator<CEffortImpl> iterator = ((CTaskImpl)object).getEffortIterator();
            while (iterator.hasNext()) {
                ObjectFactoryImpl.s_oInstance.mf_oEffortMap.remove(iterator.next().getID());
            }
        } else if (aReplicateableObjectImpl instanceof CEffortImpl) {
            HashMap<String, CEffortImpl> hashMap = ObjectFactoryImpl.s_oInstance.mf_oEffortMap;
            synchronized (hashMap) {
                ObjectFactoryImpl.s_oInstance.mf_oEffortMap.remove(string);
            }
        } else if (aReplicateableObjectImpl instanceof CPersonImpl) {
            HashMap<String, CPersonImpl> hashMap = ObjectFactoryImpl.s_oInstance.mf_oPersonMap;
            synchronized (hashMap) {
                ObjectFactoryImpl.s_oInstance.mf_oPersonMap.remove(string);
            }
        } else {
            throw new IllegalStateException("Unknown object type: " + aReplicateableObjectImpl.getClass().getCanonicalName());
        }
    }

    public static void destroy(Vector<? extends AReplicateableObjectImpl> vector) {
        for (AReplicateableObjectImpl aReplicateableObjectImpl : vector) {
            ObjectFactoryImpl.destroy(aReplicateableObjectImpl);
        }
    }

    @Override
    public void xmlize(CSimpleXMLStream cSimpleXMLStream) throws CSimpleXMLStream.XmlWriteException {
        cSimpleXMLStream.startElement(XML_TAG_NAME);
        cSimpleXMLStream.addAttribute(XML_ATT_PROJECT_COUNT, String.valueOf(this.mf_oProjectMap.size()));
        cSimpleXMLStream.addAttribute(XML_ATT_TASK_COUNT, String.valueOf(this.mf_oTaskMap.size()));
        cSimpleXMLStream.addAttribute(XML_ATT_EFFORT_COUNT, String.valueOf(this.mf_oEffortMap.size()));
        cSimpleXMLStream.addAttribute(XML_ATT_PERSON_COUNT, String.valueOf(this.mf_oPersonMap.size()));
        cSimpleXMLStream.endElement(XML_TAG_NAME);
    }

    public void xmlizePersons(CSimpleXMLStream cSimpleXMLStream) throws CSimpleXMLStream.XmlWriteException {
        CStatistic cStatistic = ProjectList.getInstance().getStatistic();
        cSimpleXMLStream.startElement(XML_PERSONLIST_TAG_NAME);
        Iterator<Map.Entry<String, CPersonImpl>> iterator = this.mf_oPersonMap.entrySet().iterator();
        Vector<CPersonImpl> vector = new Vector<CPersonImpl>();
        while (iterator.hasNext()) {
            CPersonImpl cPersonImpl = iterator.next().getValue();
            if (cStatistic.containsPerson(cPersonImpl) || MainController.getInstance().getUser() == cPersonImpl) {
                cPersonImpl.xmlize(cSimpleXMLStream);
                continue;
            }
            vector.add(cPersonImpl);
        }
        cSimpleXMLStream.endElement(XML_PERSONLIST_TAG_NAME);
        if (vector.size() > 0) {
            ObjectFactoryImpl.destroy(vector);
            MainController.getInstance().notifyControllers(MainController.EUpdateMessage.PersonsDeleted, vector);
        }
    }

    public static class CPersonListContainer
    extends AXMLObjectContainer<HashMap<?, ?>> {
        private static final CPersonImpl.CPersonContainer PERSON_CONTAINER = new CPersonImpl.CPersonContainer();

        @Override
        protected HashMap<?, ?> createContainedObject(Attributes attributes, int n) {
            return ObjectFactoryImpl.getInstance().mf_oPersonMap;
        }

        @Override
        protected AXMLObjectContainer<?> newChildContainer(String string, int n) {
            if (string.equals("person")) {
                return PERSON_CONTAINER;
            }
            return null;
        }
    }

    public static class CObjectFactoryContainer
    extends AChildlessXMLObjectContainer<ObjectFactoryImpl> {
        @Override
        protected ObjectFactoryImpl createContainedObject(Attributes attributes, int n) {
            int n2 = Integer.parseInt(attributes.getValue(ObjectFactoryImpl.XML_ATT_PROJECT_COUNT));
            int n3 = Integer.parseInt(attributes.getValue(ObjectFactoryImpl.XML_ATT_TASK_COUNT));
            int n4 = Integer.parseInt(attributes.getValue(ObjectFactoryImpl.XML_ATT_EFFORT_COUNT));
            int n5 = Integer.parseInt(attributes.getValue(ObjectFactoryImpl.XML_ATT_PERSON_COUNT));
            ObjectFactoryImpl.createInstance(n2, n3, n4, n5);
            return ObjectFactoryImpl.getInstance();
        }
    }
}

