/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.resources;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.filehandling.DirectoryUtil;
import com.mayastudios.fred.client.resources.FredInfo;
import com.mayastudios.fred.client.resources.configfile.ConfigFile;
import com.mayastudios.fred.client.resources.configfile.XmlConfigFile;
import java.io.File;
import java.io.IOException;
import java.util.Locale;

public class GlobalSettings {
    private static final String SETTINGS_FILE_NAME = "settings.xml";
    private static final File SETTINGS_FILE_PATH;
    private static final String PDFREADER_KEY = "pdfreaderpath";
    private static final String MANUAL_KEY = "manualpath";
    private static final String LANGUAGE_KEY = "language";
    private static final String LAST_VERSION_KEY = "lastVersion";
    private static final GlobalSettings INSTANCE;
    private final ConfigFile mf_oSettingsFile = SETTINGS_FILE_PATH != null ? new XmlConfigFile(SETTINGS_FILE_PATH) : new ConfigFile();

    private GlobalSettings() {
        String string = this.mf_oSettingsFile.getAsString(LANGUAGE_KEY);
        if (string == null) {
            this.mf_oSettingsFile.set(LANGUAGE_KEY, ELanguage.getSystemLocale().name());
        } else {
            try {
                ELanguage.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.mf_oSettingsFile.set(LANGUAGE_KEY, ELanguage.getSystemLocale().name());
            }
        }
        String string2 = this.mf_oSettingsFile.getAsString(LAST_VERSION_KEY);
        if (string2 == null || string2.trim().length() == 0) {
            this.mf_oSettingsFile.set(LAST_VERSION_KEY, FredInfo.VERSION_NUMBER);
            this.saveGlobalSettingsImpl();
        }
    }

    public static String getPDFReaderPath() {
        return GlobalSettings.INSTANCE.mf_oSettingsFile.getAsString(PDFREADER_KEY, false);
    }

    public static void setPDFReaderPath(String string) {
        GlobalSettings.INSTANCE.mf_oSettingsFile.set(PDFREADER_KEY, string);
    }

    public static String getManualPath() {
        return GlobalSettings.INSTANCE.mf_oSettingsFile.getAsString(MANUAL_KEY, false);
    }

    public static void setManualPath(String string) {
        GlobalSettings.INSTANCE.mf_oSettingsFile.set(MANUAL_KEY, string);
    }

    public static ELanguage getLanguage() {
        return ELanguage.valueOf(GlobalSettings.INSTANCE.mf_oSettingsFile.getAsString(LANGUAGE_KEY));
    }

    public static void setLanguage(ELanguage eLanguage) {
        if (eLanguage == null) {
            throw new IllegalArgumentException("Must not be null.");
        }
        GlobalSettings.INSTANCE.mf_oSettingsFile.set(LANGUAGE_KEY, eLanguage.name());
    }

    public static String getLastUsedVersion() {
        return GlobalSettings.INSTANCE.mf_oSettingsFile.getAsString(LAST_VERSION_KEY, false);
    }

    public static void saveGlobalSettings() {
        INSTANCE.saveGlobalSettingsImpl();
    }

    private void saveGlobalSettingsImpl() {
        if (!(this.mf_oSettingsFile instanceof XmlConfigFile)) {
            return;
        }
        try {
            ((XmlConfigFile)this.mf_oSettingsFile).storeToXML();
        }
        catch (IOException iOException) {
            MainController.LOGGER.warn("Could not save global settings.", (Throwable)iOException);
        }
    }

    static {
        File file = DirectoryUtil.getUserConfigDir();
        SETTINGS_FILE_PATH = file == null ? null : new File(file, SETTINGS_FILE_NAME);
        INSTANCE = new GlobalSettings();
    }

    public static enum ELanguage {
        ENGLISH(Locale.ENGLISH),
        FRENCH(Locale.FRENCH),
        GERMAN(Locale.GERMAN);

        private final Locale mf_oLocale;

        private ELanguage(Locale locale) {
            this.mf_oLocale = locale;
        }

        public Locale getLocale() {
            return this.mf_oLocale;
        }

        public static ELanguage getSystemLocale() {
            Locale locale = Locale.getDefault();
            if (locale.getLanguage().equals("de")) {
                return GERMAN;
            }
            if (locale.getLanguage().equals("fr")) {
                return FRENCH;
            }
            return ENGLISH;
        }
    }
}

