/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.resources;

import com.mayastudios.fred.client.resources.DataMask;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.rmi.server.UID;
import java.util.Random;

public class ID {
    private static final char[] CYPHERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    public static final int MIN_RADIX = 2;
    public static final int MAX_RADIX;
    public static final int UID_RADIX;
    public static final int UID_SIZE = 25;

    public static String createNewID(char c) {
        UID uID = new UID();
        DataCapturer dataCapturer = new DataCapturer();
        try {
            uID.write(dataCapturer);
        }
        catch (IOException iOException) {
            throw new Error("Unreachable Code", iOException);
        }
        long l = DataMask.reverse(dataCapturer.valueLong);
        int n = dataCapturer.valueInt;
        short s = DataMask.reverse(dataCapturer.valueShort);
        BigInteger bigInteger = BigInteger.ZERO;
        bigInteger = ID.append(bigInteger, l);
        bigInteger = ID.append(bigInteger, s);
        bigInteger = ID.append(bigInteger, n);
        String string = ID.toRadix(bigInteger, UID_RADIX);
        if (string.length() > 25) {
            return c + string.substring(string.length() - 25 - 1);
        }
        String string2 = c + ID.getRandomString(25 - string.length() - 2, UID_RADIX) + "|" + string;
        return string2;
    }

    static BigInteger append(BigInteger bigInteger, long l) {
        bigInteger = bigInteger.shiftLeft(64);
        if (l > 0L) {
            bigInteger = bigInteger.add(BigInteger.valueOf(l));
        } else if (l < 0L) {
            bigInteger = bigInteger.setBit(63);
            if (l > Long.MIN_VALUE) {
                bigInteger = bigInteger.add(BigInteger.valueOf(l * -1L));
            }
        }
        return bigInteger;
    }

    static BigInteger append(BigInteger bigInteger, int n) {
        bigInteger = bigInteger.shiftLeft(32);
        if (n > 0) {
            bigInteger = bigInteger.add(BigInteger.valueOf(n));
        } else if (n < 0) {
            bigInteger = bigInteger.setBit(31);
            if (n > Integer.MIN_VALUE) {
                bigInteger = bigInteger.add(BigInteger.valueOf((long)n * -1L));
            }
        }
        return bigInteger;
    }

    static BigInteger append(BigInteger bigInteger, short s) {
        bigInteger = bigInteger.shiftLeft(16);
        if (s > 0) {
            bigInteger = bigInteger.add(BigInteger.valueOf(s));
        } else if (s < 0) {
            bigInteger = bigInteger.setBit(15);
            if (s > Short.MIN_VALUE) {
                bigInteger = bigInteger.add(BigInteger.valueOf((long)s * -1L));
            }
        }
        return bigInteger;
    }

    public static String getRandomString(int n, int n2) {
        if (n2 < 2 || n2 > MAX_RADIX) {
            throw new IllegalArgumentException("radix out of range (2.." + MAX_RADIX + ")");
        }
        int n3 = (int)Math.ceil(Math.log(Math.pow(n2, n)) / Math.log(2.0));
        BigInteger bigInteger = BigInteger.probablePrime(n3, new Random(System.currentTimeMillis() ^ Double.doubleToLongBits(Math.random())));
        bigInteger = bigInteger.add(BigInteger.ONE.shiftLeft(n3 + 1));
        String string = ID.toRadix(bigInteger, n2);
        return string.substring(string.length() - n);
    }

    public static String toRadix(BigInteger bigInteger, int n) {
        if (n < 2 || n > MAX_RADIX) {
            throw new IllegalArgumentException("radix out of range (2.." + MAX_RADIX + ")");
        }
        if (bigInteger.equals(BigInteger.ZERO)) {
            return new String(CYPHERS, 0, 1).intern();
        }
        StringBuffer stringBuffer = new StringBuffer(bigInteger.bitLength() / 62 + 2);
        BigInteger bigInteger2 = bigInteger.abs();
        BigInteger bigInteger3 = BigInteger.valueOf(n);
        while (bigInteger2.compareTo(BigInteger.ZERO) > 0) {
            BigInteger[] bigIntegerArray = bigInteger2.divideAndRemainder(bigInteger3);
            bigInteger2 = bigIntegerArray[0];
            int n2 = bigIntegerArray[1].intValue();
            stringBuffer.append(CYPHERS[n2]);
        }
        if (bigInteger.signum() == -1) {
            stringBuffer.append('-');
        }
        return stringBuffer.reverse().toString();
    }

    static {
        UID_RADIX = MAX_RADIX = CYPHERS.length;
    }

    private static class DataCapturer
    extends OutputStream
    implements DataOutput {
        long valueLong;
        int valueInt;
        short valueShort;

        @Override
        public void write(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void write(byte[] byArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeBoolean(boolean bl) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeByte(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeBytes(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeChar(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeChars(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeDouble(double d) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeFloat(float f) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeInt(int n) {
            this.valueInt = n;
        }

        @Override
        public void writeLong(long l) {
            this.valueLong = l;
        }

        @Override
        public void writeShort(int n) {
            this.valueShort = (short)n;
        }

        @Override
        public void writeUTF(String string) {
            throw new UnsupportedOperationException();
        }
    }
}

