/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.resources;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.filehandling.DirectoryUtil;
import com.mayastudios.mscl.exceptions.CExecutionException;
import com.mayastudios.systeminfo.SystemInfo;
import java.io.File;
import java.io.IOException;

public class ManualHelper {
    public static final String[][] LINUX_PDFVIEWER = new String[][]{{"Acrobat Reader", "acroread"}, {"KPDF", "kpdf"}, {"Evince", "evince"}, {"GNOME PDF Viewer", "gpdf"}, {"Xpdf", "xpdf"}, {"KGhostView", "kghostview"}, {"GGV", "ggv"}, {"gv", "gv"}};
    private static final File DEFAULT_MANUAL_PATH = new File(DirectoryUtil.getInstallDirectory(), "Manual.pdf");

    private ManualHelper() {
    }

    public static boolean isPDFReaderAutoDetectionSupported() {
        switch (SystemInfo.OSTYPE) {
            case Windows: 
            case Linux: {
                return true;
            }
        }
        return false;
    }

    public static String getDefaultManualPath() {
        return DEFAULT_MANUAL_PATH.toString();
    }

    public static void showManual(String string, String string2) throws IOException, InterruptedException, CExecutionException {
        if (!"".equals(string)) {
            ManualHelper._show(string, string2);
            return;
        }
        switch (SystemInfo.OSTYPE) {
            case Windows: {
                ManualHelper._showWindowsAuto(string2);
                return;
            }
            case Linux: {
                ManualHelper._showLinuxAuto(string2);
                return;
            }
        }
        throw new CExecutionException("Konnte den zu verwendenen PDF-Reader nicht automatisch bestimmen.");
    }

    private static void _show(String string, String string2) throws IOException {
        String[] stringArray = new String[]{string, string2};
        Runtime.getRuntime().exec(stringArray, null, new File("."));
    }

    private static void _showWindowsAuto(String string) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + string);
        process.waitFor();
    }

    private static void _showLinuxAuto(String string) throws CExecutionException {
        Runtime runtime = Runtime.getRuntime();
        for (int i = 0; i < LINUX_PDFVIEWER.length; ++i) {
            try {
                String[] stringArray = new String[]{LINUX_PDFVIEWER[i][1], string};
                Process process = runtime.exec(stringArray, null, new File("."));
                process.waitFor();
                return;
            }
            catch (Exception exception) {
                MainController.LOGGER.info("", (Throwable)exception);
                continue;
            }
        }
        throw new CExecutionException("Konnte den zu verwendenen PDF-Reader nicht automatisch bestimmen.");
    }
}

