/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.servertuning;

import com.mayastudios.fred.client.servertuning.IEffortEx;
import de.sopra06.domainmodel.Effort;
import de.sopra06.domainmodel.Person;
import de.sopra06.domainmodel.Task;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class CTunedEffort
implements Effort {
    private static final String PAUSE_DURATION_PATTERN_FORMAT = "##PAUSE:%d##%s";
    private static final Pattern PAUSE_DURATION_PATTERN_REGEX = Pattern.compile("^##PAUSE:([0-9]+)##");
    private final IEffortEx mf_oRealEffort;

    public CTunedEffort(IEffortEx iEffortEx) {
        this.mf_oRealEffort = iEffortEx;
    }

    public IEffortEx getInnerEffort() {
        return this.mf_oRealEffort;
    }

    public Calendar getBegin() {
        return this.mf_oRealEffort.getBegin();
    }

    public int getCategory() {
        return this.mf_oRealEffort.getCategory();
    }

    public String getDescription() {
        if (this.mf_oRealEffort.getPauseDuration() == 0 && "".equals(this.mf_oRealEffort.getDescription())) {
            return "";
        }
        return String.format(PAUSE_DURATION_PATTERN_FORMAT, this.mf_oRealEffort.getPauseDuration(), this.mf_oRealEffort.getDescription());
    }

    public int getDuration() {
        return this.mf_oRealEffort.getDuration();
    }

    public Person getPerson() {
        return this.mf_oRealEffort.getPerson();
    }

    public Task getTask() {
        return this.mf_oRealEffort.getTask();
    }

    public void setBegin(Calendar calendar) {
        this.mf_oRealEffort.setBegin(calendar);
    }

    public void setCategory(int n) {
        this.mf_oRealEffort.setCategory(n);
    }

    public void setDescription(String string) {
        Matcher matcher = PAUSE_DURATION_PATTERN_REGEX.matcher(string);
        if (matcher.lookingAt() && matcher.groupCount() == 1) {
            this.mf_oRealEffort.setPauseDuration(Integer.parseInt(matcher.group(1)));
            string = string.substring(matcher.group().length());
        }
        this.mf_oRealEffort.setDescription(string);
    }

    public void setDuration(int n) {
        this.mf_oRealEffort.setDuration(n);
    }

    public void setPerson(Person person) {
        this.mf_oRealEffort.setPerson(person);
    }

    public void setTask(Task task) {
        this.mf_oRealEffort.setTask(task);
    }

    public String getID() {
        return this.mf_oRealEffort.getID();
    }

    public void setID(String string) {
        this.mf_oRealEffort.setID(string);
    }
}

