/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.util.avltree;

import com.mayastudios.fred.client.util.avltree.AVLNode;
import com.mayastudios.fred.client.util.avltree.AVLTree;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;

class NodeIteratorLevel<E extends Comparable<? super E>>
implements Iterator<E> {
    private AVLTree<E> m_AVLTree = null;
    private AVLNode<E> m_NodeLastVisited = null;
    private ConcurrentLinkedQueue<AVLNode<E>> m_Queue;

    public NodeIteratorLevel(AVLTree<E> aVLTree, AVLNode<E> aVLNode) {
        this.m_AVLTree = aVLTree;
        this.m_Queue = new ConcurrentLinkedQueue();
        this.m_Queue.add(aVLNode);
    }

    @Override
    public boolean hasNext() {
        return !this.m_Queue.isEmpty();
    }

    @Override
    public E next() {
        this.m_NodeLastVisited = this.m_Queue.poll();
        if (this.m_NodeLastVisited != null) {
            if (this.m_NodeLastVisited.m_NodeLeft != null) {
                this.m_Queue.add(this.m_NodeLastVisited.m_NodeLeft);
            }
            if (this.m_NodeLastVisited.m_NodeRight != null) {
                this.m_Queue.add(this.m_NodeLastVisited.m_NodeRight);
            }
        }
        return this.m_NodeLastVisited.m_Element;
    }

    @Override
    public void remove() {
        if (this.m_NodeLastVisited != null) {
            this.m_AVLTree.remove(this.m_NodeLastVisited);
            this.m_NodeLastVisited = null;
        }
    }
}

