/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.view;

import com.mayastudios.fred.client.model.CColumn;
import com.mayastudios.fred.client.model.CColumnModel;
import com.mayastudios.fred.client.model.CEffortImpl;
import com.mayastudios.fred.client.model.CEffortTableModel;
import com.mayastudios.fred.client.model.CProjectImpl;
import com.mayastudios.mscl.grafics.CColorEx;
import com.mayastudios.mscl.mwt.widgets.CTableEx;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.SystemColor;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class CEffortTableRenderer
implements TableCellRenderer {
    private static final CColorEx SELECTED_FOCUS_COLOR = new CColorEx((Color)SystemColor.textHighlight);
    static final Color DEFAULT_BG = Color.WHITE;
    static final Color COLLISION_BG = new Color(255, 215, 148);
    static final Color DEFAULT_BG_SEL = SELECTED_FOCUS_COLOR;
    static final Color COLLISION_BG_SEL = SELECTED_FOCUS_COLOR.mix(COLLISION_BG, 0.5f, 255);
    private static final Color TEXT_COLOR = Color.BLACK;
    private static final Color SELECTED_TEXT_COLOR = SystemColor.textHighlightText;
    private static final Color OTHER_CAT_TEXT_COLOR = new Color(65, 130, 59);
    private static final Color OTHER_CAT_TEXT_COLOR_SEL = new Color(91, 217, 80);
    private static final CColorEx DISABLED_TEXT_COLOR = new CColorEx((Color)SystemColor.textInactiveText);
    private static final CColorEx DISABLED_TEXT_COLOR_SEL = DISABLED_TEXT_COLOR.invertColor();
    private static final Font DEFAULT_FONT = new Font("Dialog", 0, 11);
    private static final Font NOTREPLICATED_FONT = DEFAULT_FONT.deriveFont(2);
    private static final Font NOTAPPROVED_FONT = DEFAULT_FONT.deriveFont(1);
    private static final Font NOTREPLICATED_NOTAPPROVED_FONT = DEFAULT_FONT.deriveFont(3);
    private static final String ITALICS_STRING_FORMATTER = "%s ";
    private CCellContainer<JLabel> m_oLabel = new CCellContainer<JLabel>(new JLabel());
    private CCellContainer<JCheckBox> m_oCheckBox = new CCellContainer<JCheckBox>(new JCheckBox());

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        CCellContainer<JComponent> cCellContainer;
        CEffortImpl cEffortImpl = ((CEffortTableModel)jTable.getModel()).getRow(n);
        CColumn cColumn = (CColumn)jTable.getColumnModel().getColumn(n2);
        CProjectImpl cProjectImpl = cEffortImpl.getProject();
        boolean bl3 = cProjectImpl.isTeamProject();
        boolean bl4 = cProjectImpl.isUserProjectLeader();
        if (object instanceof Boolean) {
            JCheckBox jCheckBox = this.m_oCheckBox.getComponent();
            jCheckBox.setSelected((Boolean)object);
            this.m_oCheckBox.setAlignment(CCellContainer.EAlign.CENTER);
            if (cColumn.getColumnType() == CColumnModel.EColumnType.Replicated && !bl3) {
                jCheckBox.setEnabled(false);
            } else {
                jCheckBox.setEnabled(true);
            }
            cCellContainer = this.m_oCheckBox;
        } else {
            JLabel jLabel = this.m_oLabel.getComponent();
            if (!cEffortImpl.isApproved() || cEffortImpl.getAccepted() == CEffortImpl.EAccepted.NotYetAccepted) {
                if (!cEffortImpl.isReplicated() && bl3) {
                    jLabel.setFont(NOTREPLICATED_NOTAPPROVED_FONT);
                } else {
                    jLabel.setFont(NOTAPPROVED_FONT);
                }
            } else if (!cEffortImpl.isReplicated() && bl3 && !bl4) {
                jLabel.setFont(NOTREPLICATED_FONT);
            } else {
                jLabel.setFont(DEFAULT_FONT);
            }
            if (jLabel.getFont().isItalic()) {
                jLabel.setText(String.format(ITALICS_STRING_FORMATTER, object.toString()));
            } else {
                jLabel.setText(object.toString());
            }
            switch (cColumn.getColumnType()) {
                case Description: 
                case Project: 
                case Task: 
                case CategoryName: 
                case PersonFullName: {
                    this.m_oLabel.setAlignment(CCellContainer.EAlign.LEFT);
                    break;
                }
                case CategoryID: {
                    this.m_oLabel.setAlignment(CCellContainer.EAlign.RIGHT);
                    break;
                }
                default: {
                    this.m_oLabel.setAlignment(CCellContainer.EAlign.CENTER);
                }
            }
            if (cColumn.getColumnType() == CColumnModel.EColumnType.Accepted && !bl3) {
                if (bl) {
                    jLabel.setForeground((Color)DISABLED_TEXT_COLOR_SEL);
                } else {
                    jLabel.setForeground((Color)DISABLED_TEXT_COLOR);
                }
            } else if ((cColumn.getColumnType() == CColumnModel.EColumnType.CategoryID || cColumn.getColumnType() == CColumnModel.EColumnType.CategoryName) && cEffortImpl.getTask().getDefaultCategory() != cEffortImpl.getCategory()) {
                if (bl) {
                    jLabel.setForeground(OTHER_CAT_TEXT_COLOR_SEL);
                } else {
                    jLabel.setForeground(OTHER_CAT_TEXT_COLOR);
                }
            } else if (bl) {
                jLabel.setForeground(SELECTED_TEXT_COLOR);
            } else {
                jLabel.setForeground(TEXT_COLOR);
            }
            cCellContainer = this.m_oLabel;
        }
        if (bl) {
            if (cEffortImpl.isColliding() && !cEffortImpl.ignoresMistake()) {
                cCellContainer.setBackground(COLLISION_BG_SEL);
            } else {
                cCellContainer.setBackground(DEFAULT_BG_SEL);
            }
        } else if (cEffortImpl.isColliding() && !cEffortImpl.ignoresMistake()) {
            cCellContainer.setBackground(COLLISION_BG);
        } else {
            cCellContainer.setBackground(DEFAULT_BG);
        }
        return cCellContainer;
    }

    public static CTableEx.ISecondRowCallback createSecondRowRenderer(CEffortTableModel cEffortTableModel) {
        return new CSecondRowRenderer(cEffortTableModel);
    }

    private static class CSecondRowRenderer
    extends JLabel
    implements CTableEx.ISecondRowCallback {
        private static final Color SCND_TEXT_COLOR = Color.BLUE;
        private static final Color SCND_SELECTED_TEXT_COLOR = new Color(178, 199, 251);
        private final CEffortTableModel mf_oTableModel;

        public CSecondRowRenderer(CEffortTableModel cEffortTableModel) {
            this.mf_oTableModel = cEffortTableModel;
        }

        public Component getSecondRow(int n, boolean bl) {
            CEffortImpl cEffortImpl = this.mf_oTableModel.getRow(n);
            this.setText(String.format("[%s] %s", cEffortImpl.getPerson().getInitials(), cEffortImpl.getDescription()));
            this.setForeground(bl ? SCND_SELECTED_TEXT_COLOR : SCND_TEXT_COLOR);
            if (bl) {
                if (cEffortImpl.isColliding() && !cEffortImpl.ignoresMistake()) {
                    this.setBackground(COLLISION_BG_SEL);
                } else {
                    this.setBackground(DEFAULT_BG_SEL);
                }
            } else if (cEffortImpl.isColliding() && !cEffortImpl.ignoresMistake()) {
                this.setBackground(COLLISION_BG);
            } else {
                this.setBackground(DEFAULT_BG);
            }
            return this;
        }
    }

    private static class CCellContainer<Type extends JComponent>
    extends JPanel {
        private static final int HORZ_MARGIN = 3;
        private Type m_oComponent;
        private EAlign m_eAlign = EAlign.LEFT;

        CCellContainer(Type Type2) {
            this.setLayout(null);
            ((JComponent)Type2).setOpaque(false);
            this.add((Component)Type2);
            this.m_oComponent = Type2;
        }

        final Type getComponent() {
            return this.m_oComponent;
        }

        final void setAlignment(EAlign eAlign) {
            this.m_eAlign = eAlign;
        }

        @Override
        public void validate() {
            Dimension dimension = this.getSize();
            Dimension dimension2 = ((JComponent)this.m_oComponent).getPreferredSize();
            Rectangle rectangle = new Rectangle();
            rectangle.width = Math.min(dimension2.width, dimension.width - 6);
            rectangle.height = Math.min(dimension2.height, dimension.height);
            switch (this.m_eAlign) {
                case LEFT: {
                    rectangle.x = 3;
                    break;
                }
                case CENTER: {
                    rectangle.x = (dimension.width - rectangle.width) / 2;
                    break;
                }
                case RIGHT: {
                    rectangle.x = dimension.width - 3 - rectangle.width;
                }
            }
            rectangle.y = (dimension.height - rectangle.height) / 2;
            ((Component)this.m_oComponent).setBounds(rectangle);
            ((Container)this.m_oComponent).validate();
        }

        static enum EAlign {
            LEFT,
            CENTER,
            RIGHT;

        }
    }
}

