/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.view.dialogs;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.model.CPersonImpl;
import com.mayastudios.fred.client.resources.Labels;
import com.mayastudios.fred.client.resources.WorkFileSettings;
import com.mayastudios.fred.client.view.dialogs.ADialogEx;
import com.mayastudios.fred.client.view.dialogs.CTitledPanel;
import com.mayastudios.fred.client.view.dialogs.textfields.CNonEmptyTextfield;
import com.mayastudios.ixml.common.SystemInfo;
import com.mayastudios.mscl.mwt.widgets.button.CFlatButtonBorder;
import com.mayastudios.mscl.mwt.widgets.inputcontols.CTextFieldEx;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.mayastudios.mscl.mwt.trayicon.TrayIconInfo;

public class CDlgExtrasOptions
extends ADialogEx
implements ListSelectionListener {
    private static final int CONTENT_WIDTH = SystemInfo.OSTYPE == SystemInfo.EOSType.Windows ? 430 : 470;
    private static final int CONTENT_HEIGHT = 240;
    private static final String[] MINIMIZE_COMBO_TEXT = new String[]{Labels.get("MINIMIZE_TO_TASKBAR", new Object[0]), Labels.get("MINIMIZE_TO_TRAY", new Object[0])};
    private String m_strUserFirstName = null;
    private String m_strUserName = null;
    private String m_strInitials = null;
    private String m_strWorkfilePath = null;
    private JTextField m_oWorkfilePathLabel = null;
    private final JCheckBox m_oMakeBackup;
    private CNonEmptyTextfield m_oFirstNameField = null;
    private CNonEmptyTextfield m_oNameField = null;
    private CTextFieldEx m_oInitialsField = null;
    private JCheckBox m_oSaveViewsCheckBox = null;
    private JCheckBox m_oShowSecondRowCheckBox = null;
    private JCheckBox m_oConfirmQuickSplitCheckBox = null;
    private JCheckBox m_oSaveNotAcceptedCheckBox = null;
    private JComboBox m_oMinimizeActionComboBox = null;
    private CNamedPanel m_oUserDataPanel = null;
    private CNamedPanel m_oUIPanel = null;
    private CNamedPanel m_oWorkfilePanel = null;
    private CNamedPanel m_oEffortPanel = null;
    private CNamedPanel m_oCurrentlySelectedPanel = null;
    private JPanel m_oLastPanel = null;
    private JList m_oPanelList = null;
    private DefaultListModel m_oPanelModel = null;
    private CPersonImpl m_oUser = null;
    private final boolean m_bUserChangedWorkfile = false;

    public CDlgExtrasOptions() {
        super((JFrame)MainController.getInstance().getMainWindow(), Labels.get("CDLGEXTRASOPTIONS", new Object[0]), Labels.get("CDLGEXTRASOPTIONS_SUBTITLE", new Object[0]), "images/dialog-icon-options.png", true, ADialogEx.OK_BUTTON_TEXT.toString(), 3, new Dimension(CONTENT_WIDTH + 220, 240));
        this.getContentPanel().setLayout(null);
        this.m_oUserDataPanel = new CNamedPanel(Labels.get("PANELUSERDATA", new Object[0]));
        this.m_oUserDataPanel.setBounds(220, 0, CONTENT_WIDTH, 240);
        this.getContentPanel().add(this.m_oUserDataPanel);
        this.m_oUserDataPanel.setVisible(false);
        JLabel jLabel = this.addLabel(Labels.get("USERFIRSTNAME", new Object[0]), this.m_oUserDataPanel.getContentPanel(), true, 0, 0, 110, 20);
        this.m_oFirstNameField = this.addNonEmptyTextfield(this.m_oUserDataPanel.getContentPanel(), jLabel, 120, 0, 250, 20);
        this.m_oUser = MainController.getInstance().getUser();
        this.m_oFirstNameField.setText(this.m_oUser.getFirstName());
        jLabel = this.addLabel(Labels.get("USERNAME", new Object[0]), this.m_oUserDataPanel.getContentPanel(), true, 0, 30, 110, 20);
        this.m_oNameField = this.addNonEmptyTextfield(this.m_oUserDataPanel.getContentPanel(), jLabel, 120, 30, 250, 20);
        this.m_oNameField.setText(this.m_oUser.getName());
        jLabel = this.addLabel(Labels.get("PARAPH", new Object[0]), this.m_oUserDataPanel.getContentPanel(), true, 0, 60, 110, 20);
        this.m_oInitialsField = this.addMaxLengthTextfield(this.m_oUserDataPanel.getContentPanel(), 120, 60, 250, 20);
        this.m_oInitialsField.setMaxTextLength(5);
        this.m_oInitialsField.setText(this.m_oUser.getInitials());
        this.m_oUIPanel = new CNamedPanel(Labels.get("PANELUI", new Object[0]));
        this.m_oUIPanel.setBounds(220, 0, CONTENT_WIDTH, 240);
        this.getContentPanel().add(this.m_oUIPanel);
        this.m_oUIPanel.setVisible(false);
        this.m_oSaveViewsCheckBox = this.addCheckBox(Labels.get("OPTION_SAVEVIEWS", new Object[0]), this.m_oUIPanel.getContentPanel(), 0, 0, CONTENT_WIDTH - 30, 30);
        this.m_oSaveViewsCheckBox.setSelected(WorkFileSettings.getAsBoolean(WorkFileSettings.EConf.SaveViews));
        jLabel = this.addLabel(Labels.get("OPTION_MINIMIZEACTION", new Object[0]), this.m_oUIPanel.getContentPanel(), true, 0, 40, 250, 20);
        this.m_oMinimizeActionComboBox = this.addComboBox(this.m_oUIPanel.getContentPanel(), MINIMIZE_COMBO_TEXT, 20, 65, 230, 20);
        if (TrayIconInfo.isTrayIconAvailable()) {
            boolean bl = WorkFileSettings.getAsBoolean(WorkFileSettings.EConf.MinimizeToTray);
            this.m_oMinimizeActionComboBox.setSelectedIndex(bl ? 1 : 0);
        } else {
            this.m_oMinimizeActionComboBox.setSelectedIndex(0);
            this.m_oMinimizeActionComboBox.setEnabled(false);
        }
        this.m_oShowSecondRowCheckBox = this.addCheckBox(Labels.get("OPTION_SHOWSECONDROW_DEFAULT", new Object[0]), this.m_oUIPanel.getContentPanel(), 0, 95, CONTENT_WIDTH - 30, 30);
        this.m_oShowSecondRowCheckBox.setSelected(WorkFileSettings.getAsBoolean(WorkFileSettings.EConf.ShowSecondRowPerDefault));
        this.m_oConfirmQuickSplitCheckBox = this.addCheckBox(Labels.get("OPTION_CONFIRM_QUICKSPLIT", new Object[0]), this.m_oUIPanel.getContentPanel(), 0, 125, CONTENT_WIDTH - 30, 30);
        this.m_oConfirmQuickSplitCheckBox.setSelected(WorkFileSettings.getAsBoolean(WorkFileSettings.EConf.ConfirmQuickSplit));
        this.m_oWorkfilePanel = new CNamedPanel(Labels.get("PANELWORKFILE", new Object[0]));
        this.m_oWorkfilePanel.setBounds(220, 0, CONTENT_WIDTH, 240);
        this.getContentPanel().add(this.m_oWorkfilePanel);
        this.m_oWorkfilePanel.setVisible(false);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(Labels.get("WORKFILE_PATH", new Object[0])));
        jPanel.setLayout(null);
        this.m_oWorkfilePathLabel = new JTextField(MainController.getInstance().getPathToWorkFile().getAbsolutePath());
        this.m_oWorkfilePathLabel.setBounds(20, 30, 360, 20);
        this.m_oWorkfilePathLabel.setEditable(false);
        this.m_oWorkfilePathLabel.setCaretPosition(0);
        jPanel.add(this.m_oWorkfilePathLabel);
        this.m_strWorkfilePath = MainController.getInstance().getPathToWorkFile().getAbsolutePath();
        this.m_oWorkfilePathLabel.setToolTipText(this.m_strWorkfilePath);
        jPanel.setBounds(0, 0, CONTENT_WIDTH - 25, 70);
        this.m_oWorkfilePanel.getContentPanel().add(jPanel);
        this.m_oMakeBackup = this.addCheckBox(Labels.get("OPTION_MAKE_BACKUP", new Object[0]), this.m_oWorkfilePanel.getContentPanel(), 0, 80, CONTENT_WIDTH - 30, 30);
        this.m_oMakeBackup.setSelected(WorkFileSettings.getAsBoolean(WorkFileSettings.EConf.MakeBackup));
        this.m_oEffortPanel = new CNamedPanel(Labels.get("PANELEFFORT", new Object[0]));
        this.m_oEffortPanel.setBounds(220, 0, CONTENT_WIDTH, 240);
        this.getContentPanel().add(this.m_oEffortPanel);
        this.m_oEffortPanel.setVisible(false);
        this.m_oSaveNotAcceptedCheckBox = this.addCheckBox(Labels.get("OPTION_SAVENOTACCEPTED", new Object[0]), this.m_oEffortPanel.getContentPanel(), 0, 0, 390, 30);
        this.m_oSaveNotAcceptedCheckBox.setSelected(WorkFileSettings.getAsBoolean(WorkFileSettings.EConf.SaveNotAcceptedEfforts));
        this.m_oPanelList = this.addList(new DefaultListModel());
        this.m_oPanelList.setSelectionMode(0);
        this.m_oPanelList.addListSelectionListener(this);
        this.m_oPanelModel = (DefaultListModel)this.m_oPanelList.getModel();
        this.m_oPanelModel.addElement(this.m_oUserDataPanel);
        this.m_oPanelModel.addElement(this.m_oUIPanel);
        this.m_oPanelModel.addElement(this.m_oWorkfilePanel);
        this.m_oPanelModel.addElement(this.m_oEffortPanel);
        JScrollPane jScrollPane = new JScrollPane(this.m_oPanelList);
        jScrollPane.setBounds(0, 0, 200, 240);
        this.getContentPanel().add(jScrollPane);
        this.m_oPanelList.setSelectedIndex(0);
        this.m_oCurrentlySelectedPanel = (CNamedPanel)this.m_oPanelList.getSelectedValue();
        this.m_oLastPanel = this.m_oCurrentlySelectedPanel;
        this.showPanel(this.m_oCurrentlySelectedPanel);
    }

    public void showPanel(JPanel jPanel) {
        if (this.m_oLastPanel != null) {
            this.m_oLastPanel.setVisible(false);
        }
        this.m_oLastPanel = jPanel;
        jPanel.setVisible(true);
    }

    public String getFirstName() {
        return this.m_strUserFirstName;
    }

    public String getUserName() {
        return this.m_strUserName;
    }

    public String getInitials() {
        return this.m_strInitials;
    }

    public String getWorkfilePath() {
        return this.m_strWorkfilePath;
    }

    public boolean isUserChangedWorkfile() {
        return this.m_bUserChangedWorkfile;
    }

    @Override
    protected boolean onOK() {
        if (this.evaluateValidationList(true, true) != null) {
            return false;
        }
        this.m_strUserFirstName = this.m_oFirstNameField.getText();
        this.m_strUserName = this.m_oNameField.getText();
        this.m_strInitials = this.m_oInitialsField.getText();
        WorkFileSettings.set(WorkFileSettings.EConf.SaveViews, new Boolean(this.m_oSaveViewsCheckBox.isSelected()));
        WorkFileSettings.set(WorkFileSettings.EConf.ShowSecondRowPerDefault, new Boolean(this.m_oShowSecondRowCheckBox.isSelected()));
        WorkFileSettings.set(WorkFileSettings.EConf.ConfirmQuickSplit, new Boolean(this.m_oConfirmQuickSplitCheckBox.isSelected()));
        boolean bl = this.m_oMinimizeActionComboBox.getSelectedIndex() == 1;
        WorkFileSettings.set(WorkFileSettings.EConf.MinimizeToTray, new Boolean(bl));
        WorkFileSettings.set(WorkFileSettings.EConf.MakeBackup, new Boolean(this.m_oMakeBackup.isSelected()));
        WorkFileSettings.set(WorkFileSettings.EConf.SaveNotAcceptedEfforts, new Boolean(this.m_oSaveNotAcceptedCheckBox.isSelected()));
        return true;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JList jList = this.m_oPanelList;
        this.m_oCurrentlySelectedPanel = (CNamedPanel)jList.getSelectedValue();
        this.showPanel(this.m_oCurrentlySelectedPanel);
    }

    private class CNamedPanel
    extends JPanel {
        private final CTitledPanel m_oTitledPanel;

        public CNamedPanel(String string) {
            this.m_oTitledPanel = new CTitledPanel(string, "", null, true, 10);
            this.setName(string);
            this.setBorder((Border)new CFlatButtonBorder(CFlatButtonBorder.EState.RAISED));
            this.setLayout(new BorderLayout());
            this.add((Component)((Object)this.m_oTitledPanel));
            this.getContentPanel().setLayout(null);
        }

        public JPanel getContentPanel() {
            return this.m_oTitledPanel.getContentPanel();
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }
}

