/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.view.dialogs;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.ixml.common.SystemInfo;
import com.mayastudios.mscl.ResourceLoader;
import com.mayastudios.mscl.mwt.widgets.ABoundsHelperPanel;
import com.mayastudios.mscl.mwt.widgets.APaintHelperPanel;
import com.mayastudios.mscl.mwt.widgets.CSmoothLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.ImageObserver;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class CTitledPanel
extends ABoundsHelperPanel {
    private CTitleBar m_oTitleBar;
    private JPanel m_oContentPanel;
    private int m_iContentMargin;

    public CTitledPanel(String string, String string2, ImageIcon imageIcon, boolean bl, int n) {
        this(string, string2, imageIcon, bl, new JPanel(), n);
    }

    public CTitledPanel(String string, String string2, ImageIcon imageIcon, boolean bl, JPanel jPanel, int n) {
        super(true);
        this.m_oTitleBar = new CTitleBar(string, string2, imageIcon, bl);
        this.add((Component)((Object)this.m_oTitleBar));
        this.m_oContentPanel = jPanel;
        this.add(this.m_oContentPanel);
        this.m_iContentMargin = n;
    }

    public JPanel getContentPanel() {
        return this.m_oContentPanel;
    }

    public void setErrorText(String string) {
        this.m_oTitleBar.setErrorText(string);
    }

    public int getTitleBarHeight() {
        return this.m_oTitleBar.getTitleBarHeight();
    }

    protected void boundsChanged(int n, int n2, ABoundsHelperPanel.EChangeType eChangeType) {
        if (!eChangeType.isResized()) {
            return;
        }
        int n3 = this.m_oTitleBar.getTitleBarHeight();
        this.m_oTitleBar.setBounds(0, 0, n, n3);
        this.m_oContentPanel.setBounds(this.m_iContentMargin, n3 + this.m_iContentMargin, n - 2 * this.m_iContentMargin, n2 - (n3 + 2 * this.m_iContentMargin));
        this.m_oContentPanel.validate();
    }

    public static class CTitleBar
    extends ABoundsHelperPanel {
        public static final Color BG_COLOR = Color.WHITE;
        private static final int TITLEBAR_MIN_HEIGHT = 30;
        private static final int MARGIN = 10;
        private static final int TITLE_SUBTITLE_GAP = 5;
        private static final ImageIcon ERROR_IMAGE;
        private static final Font SUBTITLE_FONT;
        private static final Font TITLE_FONT;
        private CSmoothLabel m_oTitle;
        private JLabel m_oSubTitle;
        private JLabel m_oErrorText = new JLabel(ERROR_IMAGE);
        private CImageField m_oImageField;
        private JSeparator m_oSeperator = new JSeparator(0);
        private int m_iPreferredHeight;

        public CTitleBar(String string, String string2, ImageIcon imageIcon, boolean bl) {
            super(true);
            this.m_oTitle = new CSmoothLabel(string);
            this.m_oTitle.setFont(TITLE_FONT);
            Dimension dimension = this.m_oTitle.getPreferredSize();
            this.m_oTitle.setBounds(10, 10, dimension.width, dimension.height);
            this.add((Component)this.m_oTitle);
            this.m_oSubTitle = new JLabel("<html>" + string2);
            this.m_oSubTitle.setHorizontalAlignment(2);
            this.m_oSubTitle.setVerticalAlignment(1);
            this.m_oSubTitle.setLocation(10, 10 + dimension.height + 5);
            this.m_oSubTitle.setFont(SUBTITLE_FONT);
            this.add(this.m_oSubTitle);
            this.m_oErrorText.setVisible(false);
            this.m_oErrorText.setIconTextGap(5);
            this.m_oErrorText.setHorizontalAlignment(2);
            this.m_oErrorText.setVerticalAlignment(1);
            this.m_oErrorText.setLocation(10, 10 + dimension.height + 5);
            this.m_oErrorText.setFont(SUBTITLE_FONT);
            this.add(this.m_oErrorText);
            this.m_oImageField = new CImageField(imageIcon, bl);
            this.add((Component)((Object)this.m_oImageField));
            this.add(this.m_oSeperator);
            this.m_iPreferredHeight = this.m_oImageField.getPreferredSize().height > 30 ? this.m_oImageField.getPreferredSize().height : 30;
            this.m_iPreferredHeight += this.m_oSeperator.getPreferredSize().height;
        }

        public void setErrorText(String string) {
            if (string == null || "".equals(string)) {
                this.m_oErrorText.setVisible(false);
                this.m_oSubTitle.setVisible(true);
                return;
            }
            this.m_oErrorText.setText("<html>" + string);
            this.m_oSubTitle.setVisible(false);
            this.m_oErrorText.setVisible(true);
        }

        public int getTitleBarHeight() {
            return this.m_iPreferredHeight;
        }

        protected void boundsChanged(int n, int n2, ABoundsHelperPanel.EChangeType eChangeType) {
            if (!eChangeType.isResized()) {
                return;
            }
            Dimension dimension = this.m_oImageField.getPreferredSize();
            Point point = this.m_oErrorText.getLocation();
            int n3 = this.m_oSeperator.getPreferredSize().height;
            this.m_oImageField.setBounds(n - dimension.width, (n2 - dimension.height - n3) / 2, dimension.width, dimension.height);
            this.m_oSubTitle.setSize(n - dimension.width - 20, n2 - point.y);
            this.m_oErrorText.setSize(n - dimension.width - 20, n2 - point.y);
            this.m_oSeperator.setBounds(0, n2 - n3, n, n3);
        }

        protected void paintComponent(Graphics2D graphics2D) {
            Dimension dimension = this.getSize();
            graphics2D.setColor(BG_COLOR);
            graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        }

        static {
            SUBTITLE_FONT = new Font("Dialog", 0, SystemInfo.OSTYPE == SystemInfo.EOSType.Windows ? 11 : 12);
            TITLE_FONT = SUBTITLE_FONT.deriveFont(1, SUBTITLE_FONT.getSize2D() + (SystemInfo.OSTYPE == SystemInfo.EOSType.Windows ? 1.0f : 4.0f));
            try {
                ERROR_IMAGE = MainController.getResLoader().getIconExcpt("images/dialog-error.gif");
            }
            catch (ResourceLoader.ResourceLoadException resourceLoadException) {
                throw new ExceptionInInitializerError(resourceLoadException);
            }
        }

        private static class CImageField
        extends APaintHelperPanel {
            private static final Color GRADIENT_COLOR = new Color(222, 230, 248);
            private ImageIcon m_oIcon;
            private GradientPaint m_oGradient = null;

            CImageField(ImageIcon imageIcon, boolean bl) {
                this.m_oIcon = imageIcon;
                this.setLayout(null);
                Dimension dimension = this.m_oIcon != null ? new Dimension(this.m_oIcon.getIconWidth(), this.m_oIcon.getIconHeight()) : new Dimension(30, 30);
                if (bl) {
                    dimension.width += 20;
                    dimension.height += 20;
                    this.m_oGradient = new GradientPaint(0.0f, 0.0f, BG_COLOR, dimension.width, 0.0f, GRADIENT_COLOR);
                } else {
                    this.setBackground(BG_COLOR);
                }
                this.setPreferredSize(dimension);
            }

            protected void paintComponent(Graphics2D graphics2D) {
                Dimension dimension = this.getSize();
                if (this.m_oGradient != null) {
                    graphics2D.setPaint(this.m_oGradient);
                    graphics2D.fillRect(0, 0, dimension.width, dimension.height);
                    if (this.m_oIcon != null) {
                        graphics2D.drawImage(this.m_oIcon.getImage(), 10, 10, (ImageObserver)((Object)this));
                    }
                } else {
                    super.paintComponent(graphics2D);
                    if (this.m_oIcon != null) {
                        graphics2D.drawImage(this.m_oIcon.getImage(), 0, 0, (ImageObserver)((Object)this));
                    }
                }
            }
        }
    }
}

