/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.view.dialogs.effort;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.filehandling.CEffortExportCSVSettings;
import com.mayastudios.fred.client.resources.Labels;
import com.mayastudios.fred.client.resources.WorkFileSettings;
import com.mayastudios.fred.client.view.dialogs.ADialogEx;
import com.mayastudios.ixml.common.SystemInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;

public class CDlgEffortExportCSVFormat
extends ADialogEx {
    private static final int DIALOG_HEIGHT = 80;
    private static final int DIALOG_WIDTH = SystemInfo.OSTYPE == SystemInfo.EOSType.Windows ? 350 : 400;
    private JComboBox m_oDurationFormatComboBox;
    private ComboBoxModel m_oDurationFormatComboBoxModel;
    private CEffortExportCSVSettings m_oCurrentSettings;

    public CDlgEffortExportCSVFormat() {
        super((JFrame)MainController.getInstance().getMainWindow(), Labels.get("Dlg.Effort.ExportCSVFormat", new Object[0]), Labels.get("Dlg.Effort.ExportCSVFormat_Subtitle", new Object[0]), "images/dialog-icon-task.png", true, ADialogEx.OK_BUTTON_TEXT.toString(), 3, new Dimension(DIALOG_WIDTH, 80));
        CEffortExportCSVSettings cEffortExportCSVSettings = CDlgEffortExportCSVFormat.loadDefaultExportFormatSettings();
        this.m_oCurrentSettings = new CEffortExportCSVSettings();
        this.m_oCurrentSettings.setExportDurationFormat(cEffortExportCSVSettings.getExportDurationFormat());
        this.getContentPanel().setLayout(null);
        this._insertDurationFormatComboBox();
        this.getOkButton().setToolTipText(Labels.get("CDLGEFFORTEDITEFFORTTITLE_OK_TOOLTIP", new Object[0]));
    }

    private static CEffortExportCSVSettings loadDefaultExportFormatSettings() {
        CEffortExportCSVSettings cEffortExportCSVSettings = new CEffortExportCSVSettings();
        List<CEffortExportCSVSettings.IExportDurationFormat> list = CEffortExportCSVSettings.getAvailableExportDurationFormats();
        CEffortExportCSVSettings.IExportDurationFormat iExportDurationFormat = list.get(0);
        String string = WorkFileSettings.getAsString(WorkFileSettings.EConf.ExportCSVDurationFormat);
        if (string != null) {
            for (CEffortExportCSVSettings.IExportDurationFormat iExportDurationFormat2 : list) {
                if (!iExportDurationFormat2.getClass().getSimpleName().equals(string)) continue;
                iExportDurationFormat = iExportDurationFormat2;
                break;
            }
        }
        cEffortExportCSVSettings.setExportDurationFormat(iExportDurationFormat);
        return cEffortExportCSVSettings;
    }

    @Override
    protected Component getDefaultComponent() {
        return this.m_oDurationFormatComboBox;
    }

    private void _insertDurationFormatComboBox() {
        this.addLabel(Labels.get("Dlg.Effort.DurationFormat", new Object[0]), this.getContentPanel(), true, 0, 0, 120, 20);
        List<CEffortExportCSVSettings.IExportDurationFormat> list = CEffortExportCSVSettings.getAvailableExportDurationFormats();
        this.m_oDurationFormatComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
        this.m_oDurationFormatComboBox = this.addComboBox(this.getContentPanel(), this.m_oDurationFormatComboBoxModel, 130, 0, DIALOG_WIDTH - 130, 20);
        this.m_oDurationFormatComboBox.setSelectedItem(this.m_oCurrentSettings.getExportDurationFormat());
        this.m_oDurationFormatComboBox.addItemListener(new CDurationFormatItemListener());
    }

    public CEffortExportCSVSettings geSelectedSettings() {
        return this.m_oCurrentSettings;
    }

    @Override
    protected boolean onOK() {
        return true;
    }

    private void _handleDurationFormatSelectionChange() {
        CEffortExportCSVSettings.IExportDurationFormat iExportDurationFormat = (CEffortExportCSVSettings.IExportDurationFormat)this.m_oDurationFormatComboBox.getSelectedItem();
        this.m_oCurrentSettings.setExportDurationFormat(iExportDurationFormat);
        WorkFileSettings.set(WorkFileSettings.EConf.ExportCSVDurationFormat, iExportDurationFormat.getClass().getSimpleName());
    }

    private class CDurationFormatItemListener
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                CDlgEffortExportCSVFormat.this._handleDurationFormatSelectionChange();
            }
        }
    }
}

