/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.fred.client.view.dialogs.project;

import com.mayastudios.fred.client.controller.MainController;
import com.mayastudios.fred.client.model.CProjectImpl;
import com.mayastudios.fred.client.model.ProjectList;
import com.mayastudios.fred.client.resources.Labels;
import com.mayastudios.fred.client.resources.StringFunctions;
import com.mayastudios.fred.client.view.dialogs.ADialogEx;
import com.mayastudios.fred.client.view.dialogs.textfields.CNonEmptyTextfield;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextArea;

public class CDlgProjectCreate
extends ADialogEx {
    private CNonEmptyTextfield m_oNameTextfield = null;
    private JTextArea m_oCommentTextArea = null;
    private String m_strProjectName = null;
    private String m_strProjectDescription = null;

    public CDlgProjectCreate() {
        super((JFrame)MainController.getInstance().getMainWindow(), Labels.get("CDLGPROJECTCREATE", new Object[0]), Labels.get("CDLGPROJECTCREATE_SUBTITLE", new Object[0]), "images/dialog-icon-project.png", true, Labels.get("BUTTON_CREATE", new Object[0]), 3, new Dimension(470, 110));
        this.getContentPanel().setLayout(null);
        JLabel jLabel = this.addLabel(Labels.get("NAME", new Object[0]), this.getContentPanel(), true, 0, 0, 100, 20);
        this.m_oNameTextfield = this.addNonEmptyTextfield(this.getContentPanel(), jLabel, 120, 0, 350, 20);
        jLabel = this.addLabel(Labels.get("DESCRIPTION", new Object[0]), this.getContentPanel(), true, 0, 30, 100, 20);
        this.m_oCommentTextArea = super.addTextarea(this.getContentPanel(), true, 120, 30, 350, 80);
        this.m_oCommentTextArea.setLineWrap(true);
        this.m_oCommentTextArea.setWrapStyleWord(true);
    }

    public CProjectImpl getProject() {
        CProjectImpl cProjectImpl = CProjectImpl.create();
        cProjectImpl.setName(this.m_strProjectName);
        cProjectImpl.setDescription(this.m_strProjectDescription);
        return cProjectImpl;
    }

    @Override
    protected boolean onOK() {
        if (this.evaluateValidationList(true, true) != null) {
            return false;
        }
        String string = StringFunctions.isNameValid(this.m_oNameTextfield.getText());
        if (string != null) {
            this.setErrorText(string);
            return false;
        }
        if (!ProjectList.getInstance().isProjectNameValid(null, this.m_oNameTextfield.getText())) {
            this.setErrorText(Labels.get("MSG_DUPLICATE_PROJECT_NAME", new Object[0]));
            return false;
        }
        this.setErrorText(null);
        this.m_strProjectName = this.m_oNameTextfield.getText();
        this.m_strProjectDescription = this.m_oCommentTextArea.getText();
        return true;
    }
}

