/*
 * Decompiled with CFR 0.152.
 */
package de.wb.view;

import com.mayastudios.fred.client.exceptions.CFredRuntimeException;
import de.wb.control.CNewEntryListener;
import de.wb.control.IValidable;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class CURLComboBox
extends JComboBox
implements IValidable {
    private JLabel m_oCorrespondingLabel = null;
    private boolean m_bValid = false;
    private boolean m_bAllowEmptyContent;
    private Color m_oForegroundColor = null;
    private ComboBoxEditor m_oCBE = null;
    private JTextField m_oTextField = null;
    private DefaultComboBoxModel m_oOCBM = null;
    private IValidable.EErrorStatus m_eErrorStatus;

    public CURLComboBox(Vector<URL> vector, boolean bl) {
        this.addActionListener(this);
        this.aquireEditor();
        this.aquireTextField();
        this.aquireForegroundColor();
        this.m_oOCBM = new DefaultComboBoxModel<URL>(vector);
        this.setModel(this.m_oOCBM);
        this.setEditable(true);
        this.addActionListener(new CNewEntryListener());
        this.m_eErrorStatus = IValidable.EErrorStatus.WRONG_NO_ERROR;
        this.m_bAllowEmptyContent = bl;
    }

    public void setCorrespondingLabel(JLabel jLabel) {
        this.m_oCorrespondingLabel = jLabel;
        this.aquireForegroundColor();
    }

    @Override
    public boolean evaluateContent() {
        String string = null;
        this.m_bValid = true;
        this.setErrorStatus(IValidable.EErrorStatus.WRONG_NO_ERROR);
        string = this.m_oTextField.getText();
        if (string.equals("")) {
            if (!this.m_bAllowEmptyContent) {
                this.setErrorStatus(IValidable.EErrorStatus.WRONG_EMPTY_URL);
                this.m_bValid = false;
            }
        } else if (!CURLComboBox.isValidURL(string)) {
            this.setErrorStatus(IValidable.EErrorStatus.WRONG_INVALID_URL);
            this.m_bValid = false;
        }
        if (this.m_oCorrespondingLabel != null) {
            if (this.m_bValid) {
                this.setCorrespondingLabelColor(this.m_oForegroundColor);
                this.setErrorStatus(IValidable.EErrorStatus.WRONG_NO_ERROR);
            } else {
                this.setCorrespondingLabelColor(Color.RED);
            }
        }
        return this.m_bValid;
    }

    public static boolean isValidURL(String string) {
        try {
            new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        return true;
    }

    public void setErrorStatus(IValidable.EErrorStatus eErrorStatus) {
        this.m_eErrorStatus = eErrorStatus;
    }

    @Override
    public IValidable.EErrorStatus getErrorStatus() {
        return this.m_eErrorStatus;
    }

    public boolean isContainingValidContent() {
        return this.evaluateContent();
    }

    private void aquireEditor() {
        this.m_oCBE = this.getEditor();
    }

    private void aquireTextField() {
        this.aquireEditor();
        this.m_oTextField = (JTextField)this.m_oCBE.getEditorComponent();
    }

    private void aquireForegroundColor() {
        this.m_oForegroundColor = this.m_oCorrespondingLabel != null ? this.m_oCorrespondingLabel.getForeground() : Color.LIGHT_GRAY;
    }

    public URL getCurrentSelectionAsURL() {
        try {
            return new URL(this.m_oTextField.getText());
        }
        catch (MalformedURLException malformedURLException) {
            throw new CFredRuntimeException("MalformedURLException:" + malformedURLException.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.getActionCommand();
        this.setActionCommand("comboBoxEdited");
        this.fireActionEvent();
        this.setActionCommand(string);
    }

    @Override
    public void setSelectedItem(Object object) {
        super.setSelectedItem(object);
        this.m_oCBE.setItem(object.toString());
        this.m_oTextField.setCaretPosition(0);
    }

    public void setCorrespondingLabelColor(Color color) {
        if (this.m_oCorrespondingLabel != null) {
            this.m_oCorrespondingLabel.setForeground(color);
        }
    }

    @Override
    public void highlightControl(boolean bl) {
    }

    public boolean aAllowEmptyContent() {
        return this.m_bAllowEmptyContent;
    }

    public void setAllowEmptyContent(boolean bl) {
        this.m_bAllowEmptyContent = bl;
    }
}

