/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.common;

import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseEventManager<ListenerType, EventType> {
    private final LinkedList<ListenerType> mf_oListeners = new LinkedList();
    private final LinkedList<WeakReference<ListenerType>> mf_oWeakListeners = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ListenerType p_oListener, ERefType p_eRefType) {
        if (p_eRefType == ERefType.WEAK) {
            LinkedList<WeakReference<ListenerType>> linkedList = this.mf_oWeakListeners;
            synchronized (linkedList) {
                this.mf_oWeakListeners.add(new WeakReference<ListenerType>(p_oListener));
            }
        }
        LinkedList<ListenerType> linkedList = this.mf_oListeners;
        synchronized (linkedList) {
            this.mf_oListeners.add(p_oListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(ListenerType p_oListener) {
        ListIterator oIterator;
        LinkedList<Object> linkedList = this.mf_oListeners;
        synchronized (linkedList) {
            oIterator = this.mf_oListeners.listIterator();
            while (oIterator.hasNext()) {
                Object oListener = oIterator.next();
                if (oListener != p_oListener) continue;
                oIterator.remove();
                return true;
            }
        }
        linkedList = this.mf_oWeakListeners;
        synchronized (linkedList) {
            oIterator = this.mf_oWeakListeners.listIterator();
            while (oIterator.hasNext()) {
                WeakReference oRef = (WeakReference)oIterator.next();
                Object oListener = oRef.get();
                if (oListener == p_oListener) {
                    oIterator.remove();
                    return true;
                }
                if (oListener != null) continue;
                oIterator.remove();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEvent(EventType p_oEvent) {
        ListIterator oIterator;
        LinkedList<Object> linkedList = this.mf_oListeners;
        synchronized (linkedList) {
            oIterator = this.mf_oListeners.listIterator();
            while (oIterator.hasNext()) {
                Object oListener = oIterator.next();
                this.notifyListener(oListener, p_oEvent);
            }
        }
        linkedList = this.mf_oWeakListeners;
        synchronized (linkedList) {
            oIterator = this.mf_oWeakListeners.listIterator();
            while (oIterator.hasNext()) {
                WeakReference oRef = (WeakReference)oIterator.next();
                Object oListener = oRef.get();
                if (oListener != null) {
                    this.notifyListener(oListener, p_oEvent);
                    continue;
                }
                oIterator.remove();
            }
        }
    }

    protected abstract void notifyListener(ListenerType var1, EventType var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ERefType {
        REGULAR,
        WEAK;

    }
}

