/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.ixml.common;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrappedText {
    private final String[] mf_astrLines;
    private final int mf_iLineHeight;
    private final int mf_iWidth;

    public WrappedText(String p_strText, Font p_oTextFont, Graphics p_oDC, int p_iMaxWidth, boolean p_bIsHTML) {
        FontMetrics oFontMetrics = p_oDC.getFontMetrics(p_oTextFont);
        FontMetrics oBoldMetrics = p_bIsHTML ? p_oDC.getFontMetrics(p_oTextFont.deriveFont(1)) : null;
        this.mf_iLineHeight = oFontMetrics.getHeight();
        if (p_bIsHTML) {
            p_strText = p_strText.replace("<", "&lt;").replace(">", "&gt;");
        }
        String[] astrTextLines = p_strText.split("\n");
        Vector<String> oRealLines = new Vector<String>();
        int iMaxTextWidth = 0;
        Bold oIsBold = p_bIsHTML ? new Bold() : null;
        for (String strLine : astrTextLines) {
            int iMaxLineWidth = WrappedText._wrapLine(strLine, p_iMaxWidth, oFontMetrics, oBoldMetrics, oRealLines, oIsBold);
            iMaxTextWidth = Math.max(iMaxLineWidth, iMaxTextWidth);
        }
        this.mf_astrLines = oRealLines.toArray(new String[oRealLines.size()]);
        this.mf_iWidth = iMaxTextWidth;
    }

    private static int _wrapLine(String p_strLine, int p_iMaxWidth, FontMetrics p_oFontMetrics, FontMetrics p_oBoldMetrics, Vector<String> p_oLines, Bold p_oIsBold) {
        if (p_strLine.indexOf(32) == -1) {
            p_oLines.add(p_strLine);
            return Math.min(p_oFontMetrics.stringWidth(p_strLine), p_iMaxWidth);
        }
        String[] astrWords = p_strLine.split(" ");
        int iSpaceWidth = p_oFontMetrics.charWidth(' ');
        StringBuilder oCurLine = new StringBuilder(Math.min(150, p_strLine.length()));
        int iCurXPos = 0;
        int iMaxTextWidth = 0;
        for (String strCurWord : astrWords) {
            int iWordWidth;
            if (p_oIsBold != null) {
                String[] astrParts = strCurWord.split("\\[b\\]");
                boolean bBoldEnd = strCurWord.endsWith("[b]");
                iWordWidth = -1;
                strCurWord = "";
                for (String strPart : astrParts) {
                    if (iWordWidth == -1) {
                        iWordWidth = 0;
                    } else {
                        strCurWord = strCurWord + (p_oIsBold.m_bIsBold ? "</b>" : "<b>");
                        p_oIsBold.m_bIsBold = !p_oIsBold.m_bIsBold;
                    }
                    strCurWord = strCurWord + strPart;
                    if (!p_oIsBold.m_bIsBold) {
                        iWordWidth += p_oFontMetrics.stringWidth(strPart);
                        continue;
                    }
                    iWordWidth += p_oBoldMetrics.stringWidth(strPart);
                }
                if (bBoldEnd) {
                    strCurWord = strCurWord + (p_oIsBold.m_bIsBold ? "</b>" : "<b>");
                    p_oIsBold.m_bIsBold = !p_oIsBold.m_bIsBold;
                }
            } else {
                iWordWidth = p_oFontMetrics.stringWidth(strCurWord);
            }
            if (iCurXPos + iWordWidth + iSpaceWidth >= p_iMaxWidth) {
                if (iCurXPos != 0) {
                    p_oLines.add(oCurLine.toString());
                    if (iCurXPos > iMaxTextWidth) {
                        iMaxTextWidth = iCurXPos;
                    }
                    oCurLine = new StringBuilder(Math.min(150, p_strLine.length()));
                }
                oCurLine.append(strCurWord);
                iCurXPos = iWordWidth;
                continue;
            }
            if (iCurXPos == 0) {
                oCurLine.append(strCurWord);
                iCurXPos += iWordWidth;
                continue;
            }
            oCurLine.append(" " + strCurWord);
            iCurXPos += iSpaceWidth + iWordWidth;
        }
        p_oLines.add(oCurLine.toString());
        iMaxTextWidth = Math.max(iCurXPos, iMaxTextWidth);
        return iMaxTextWidth;
    }

    public int getLineCount() {
        return this.mf_astrLines.length;
    }

    public int getLineHeight() {
        return this.mf_iLineHeight;
    }

    public int getWidth() {
        return this.mf_iWidth;
    }

    public int getHeight() {
        return this.mf_iLineHeight * this.mf_astrLines.length;
    }

    public String[] getLines() {
        return this.mf_astrLines;
    }

    private static class Bold {
        public boolean m_bIsBold = false;

        private Bold() {
        }
    }
}

