/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.systeminfo;

import com.mayastudios.systeminfo.SystemInfo;

public class JavaInfo {
    public static final JavaVendor VENDOR = JavaInfo.determineVendor();

    private JavaInfo() {
    }

    private static JavaVendor determineVendor() {
        String string = System.getProperty("java.vendor");
        for (JavaVendor javaVendor : JavaVendor.values()) {
            if (javaVendor == JavaVendor.Unknown || !javaVendor.toString().equals(string)) continue;
            return javaVendor;
        }
        return JavaVendor.Unknown;
    }

    public static String getJavaInfo() {
        if (VENDOR == JavaVendor.Sun || VENDOR == JavaVendor.Apple) {
            return "Java Runtime Environment vendor:                " + VENDOR.name() + " (" + VENDOR.toString() + ")" + SystemInfo.LINE_SEPERATOR + "Java Runtime Environment version:               " + System.getProperty("java.version") + SystemInfo.LINE_SEPERATOR + "Java Virtual Machine implementation name:       " + System.getProperty("java.vm.name") + SystemInfo.LINE_SEPERATOR + "Java Runtime Environment specification version: " + System.getProperty("java.specification.version") + SystemInfo.LINE_SEPERATOR + "Name of JIT compiler to use:                    " + System.getProperty("java.compiler", "not used");
        }
        return "Java Runtime Environment vendor:                " + System.getProperty("java.vendor") + SystemInfo.LINE_SEPERATOR + "Java vendor URL:                                " + System.getProperty("java.vendor.url") + SystemInfo.LINE_SEPERATOR + "Java Runtime Environment version:               " + System.getProperty("java.version") + SystemInfo.LINE_SEPERATOR + "Java Virtual Machine specification version:     " + System.getProperty("java.vm.specification.version") + SystemInfo.LINE_SEPERATOR + "Java Virtual Machine specification vendor:      " + System.getProperty("java.vm.specification.vendor") + SystemInfo.LINE_SEPERATOR + "Java Virtual Machine specification name:        " + System.getProperty("java.vm.specification.name") + SystemInfo.LINE_SEPERATOR + "Java Virtual Machine implementation version:    " + System.getProperty("java.vm.version") + SystemInfo.LINE_SEPERATOR + "Java Virtual Machine implementation vendor:     " + System.getProperty("java.vm.vendor") + SystemInfo.LINE_SEPERATOR + "Java Virtual Machine implementation name:       " + System.getProperty("java.vm.name") + SystemInfo.LINE_SEPERATOR + "Java Runtime Environment specification version: " + System.getProperty("java.specification.version") + SystemInfo.LINE_SEPERATOR + "Java Runtime Environment specification vendor:  " + System.getProperty("java.specification.vendor") + SystemInfo.LINE_SEPERATOR + "Java Runtime Environment specification name:    " + System.getProperty("java.specification.name") + SystemInfo.LINE_SEPERATOR + "Java class format version number:               " + System.getProperty("java.class.version") + SystemInfo.LINE_SEPERATOR + "Name of JIT compiler to use:                    " + System.getProperty("java.compiler", "unknown");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JavaVendor {
        Sun("Sun Microsystems Inc."),
        Apple("Apple Inc."),
        Unknown(System.getProperty("java.vendor", "unknown vendor"));

        private final String m_vendorName;

        private JavaVendor(String string2) {
            this.m_vendorName = string2;
        }

        public String toString() {
            return this.m_vendorName;
        }
    }
}

