/*
 * Decompiled with CFR 0.152.
 */
package com.mayastudios.systeminfo;

import com.mayastudios.systeminfo.Helpers;
import com.mayastudios.systeminfo.SystemInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MacOSInfo
extends SystemInfo {
    private static final String UNKNOWN_PROCESSOR = "Unknown Processor";
    private final MacOSVersion m_version;
    private final String m_versionNumber = System.getProperty("os.version");
    private final String m_processorName;
    private final SystemInfo.SystemArch m_systemArch;
    private final long m_totalMemory;
    private final String m_modelName;

    MacOSInfo() {
        super(MacOSInfo.determineJavaArch());
        String string = System.getProperty("os.name").toLowerCase();
        this.m_version = "mac os x".equals(string) ? (this.m_versionNumber.startsWith("10.0") ? MacOSVersion.MacOSXCheeta : (this.m_versionNumber.startsWith("10.1") ? MacOSVersion.MacOSXPuma : (this.m_versionNumber.startsWith("10.2") ? MacOSVersion.MacOSXJaguar : (this.m_versionNumber.startsWith("10.3") ? MacOSVersion.MacOSXPanther : (this.m_versionNumber.startsWith("10.4") ? MacOSVersion.MacOSXTiger : (this.m_versionNumber.startsWith("10.5") ? MacOSVersion.MacOSXLeopard : (this.m_versionNumber.startsWith("10.6") ? MacOSVersion.MacOSXSnowLeopard : MacOSVersion.MacOSXUnknown))))))) : (this.m_versionNumber.startsWith("8") ? MacOSVersion.MacOS8 : (this.m_versionNumber.startsWith("9") ? MacOSVersion.MacOS9 : MacOSVersion.Unknown));
        this.m_processorName = MacOSInfo.determineProcessorName();
        this.m_systemArch = MacOSInfo.determineSystemArch(this.m_processorName);
        this.m_totalMemory = MacOSInfo.determineTotalMemory();
        this.m_modelName = MacOSInfo.determineModelName();
    }

    private static SystemInfo.JavaArch determineJavaArch() {
        String string = System.getProperty("os.arch");
        if ("PowerPC".equals(string) || "ppc".equals(string)) {
            return SystemInfo.JavaArch.PowerPC;
        }
        if ("i386".equals(string)) {
            return SystemInfo.JavaArch.x86;
        }
        if ("x86_64".equals(string)) {
            return SystemInfo.JavaArch.x64;
        }
        return SystemInfo.JavaArch.Unknown;
    }

    private static String determineProcessorName() {
        try {
            Process process = Runtime.getRuntime().exec("system_profiler SPHardwareDataType");
            InputStream inputStream = process.getInputStream();
            StringWriter stringWriter = new StringWriter();
            try {
                int n;
                while ((n = inputStream.read()) != -1) {
                    stringWriter.write(n);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String string = null;
            Matcher matcher = Pattern.compile("^\\s*Processor Name:\\s+(.+)$", 8).matcher(stringWriter.toString());
            if (matcher.find()) {
                string = matcher.group(1);
            }
            if ((matcher = Pattern.compile("^\\s*Processor Speed:\\s+(.+)$", 8).matcher(stringWriter.toString())).find()) {
                if (string == null) {
                    string = UNKNOWN_PROCESSOR;
                }
                string = string + " @ " + matcher.group(1);
            }
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static SystemInfo.SystemArch determineSystemArch(String string) {
        try {
            String string2;
            Process process = Runtime.getRuntime().exec("machine");
            InputStream inputStream = process.getInputStream();
            StringWriter stringWriter = new StringWriter();
            try {
                int n;
                while ((n = inputStream.read()) != -1) {
                    stringWriter.write(n);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if ((string2 = stringWriter.toString()).startsWith("ppc")) {
                return SystemInfo.SystemArch.PowerPC;
            }
            if ("i486".equals(string2)) {
                if (string.startsWith("Intel Pentium M") || string.startsWith("Intel Core Solo") || string.startsWith("Intel Core Duo") || string.startsWith(UNKNOWN_PROCESSOR)) {
                    return SystemInfo.SystemArch.x86;
                }
                return SystemInfo.SystemArch.x64;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return SystemInfo.SystemArch.Unknown;
    }

    private static long determineTotalMemory() {
        long l = Helpers.determineTotalPhysicalMemory();
        if (l != 0L) {
            return l;
        }
        try {
            Matcher matcher;
            Process process = Runtime.getRuntime().exec("system_profiler SPHardwareDataType");
            InputStream inputStream = process.getInputStream();
            StringWriter stringWriter = new StringWriter();
            try {
                int n;
                while ((n = inputStream.read()) != -1) {
                    stringWriter.write(n);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!(matcher = Pattern.compile("^\\s*Memory:\\s+(.+) (GB|MB)$", 8).matcher(stringWriter.toString())).find()) {
                return 0L;
            }
            long l2 = Long.parseLong(matcher.group(1));
            if ("GB".equals(matcher.group(2))) {
                return l2 * 1024L * 1024L * 1024L;
            }
            return l2 * 1024L * 1024L;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    private static String determineModelName() {
        try {
            Process process = Runtime.getRuntime().exec("system_profiler SPHardwareDataType");
            InputStream inputStream = process.getInputStream();
            StringWriter stringWriter = new StringWriter();
            try {
                int n;
                while ((n = inputStream.read()) != -1) {
                    stringWriter.write(n);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String string = null;
            Matcher matcher = Pattern.compile("^\\s*Model Name:\\s+(.+)$", 8).matcher(stringWriter.toString());
            if (!matcher.find()) {
                return "Unknown model";
            }
            string = matcher.group(1);
            matcher = Pattern.compile("^\\s*Model Identifier:\\s+(.+)$", 8).matcher(stringWriter.toString());
            if (matcher.find()) {
                string = string + " (" + matcher.group(1) + ")";
            }
            return string;
        }
        catch (Exception exception) {
            return "Unknown model";
        }
    }

    public String getOsName() {
        return this.m_version.toString();
    }

    public String getSystemCodename() {
        return this.m_version.getCodename();
    }

    public String getSystemVersionNumber() {
        return this.m_versionNumber;
    }

    public MacOSVersion getMacOSVersion() {
        return this.m_version;
    }

    public boolean isMacOSX() {
        return this.m_version.isMacOSX();
    }

    public String getProcessorName() {
        return this.m_processorName;
    }

    public SystemInfo.SystemArch getSystemArch() {
        return this.m_systemArch;
    }

    public long getTotalPhysicalMemorySize() {
        return this.m_totalMemory;
    }

    public String getModelName() {
        return this.m_modelName;
    }

    public String toString() {
        return super.toString() + LINE_SEPERATOR + LINE_SEPERATOR + "Model Name: " + this.m_modelName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MacOSVersion {
        MacOS8("Mac OS 8", null, false),
        MacOS9("Mac OS 9", null, false),
        MacOSXCheeta("Mac OS X - Cheeta", "cheeta", true),
        MacOSXPuma("Mac OS X - Puma", "puma", true),
        MacOSXJaguar("Mac OS X - Jaguar", "jaguar", true),
        MacOSXPanther("Mac OS X - Panther", "panther", true),
        MacOSXTiger("Mac OS X - Tiger", "tiger", true),
        MacOSXLeopard("Mac OS X - Leopard", "leopard", true),
        MacOSXSnowLeopard("Mac OS X - Snow Leopard", "snow leopard", true),
        MacOSXUnknown("Unknown Mac OS X", null, true),
        Unknown("Unknown Mac OS", null, false);

        private final String m_name;
        private final String m_codename;
        private final boolean m_isMacOSX;

        private MacOSVersion(String string2, String string3, boolean bl) {
            this.m_name = string2;
            this.m_codename = string3;
            this.m_isMacOSX = bl;
        }

        public String getCodename() {
            return this.m_codename;
        }

        public String toString() {
            return this.m_name;
        }

        public boolean isMacOSX() {
            return this.m_isMacOSX;
        }
    }
}

