/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpx;

import com.tapsterrock.mpx.MPXException;
import com.tapsterrock.mpx.MPXFile;
import com.tapsterrock.mpx.MPXNumberFormat;

public final class MPXCurrency
extends Number {
    private MPXNumberFormat m_format;
    private double m_amount;

    MPXCurrency(MPXNumberFormat format, double amount) {
        this.m_format = format;
        this.m_amount = amount;
    }

    public String toString() {
        return this.m_format.format(this.m_amount);
    }

    public int intValue() {
        return (int)this.m_amount;
    }

    public long longValue() {
        return (long)this.m_amount;
    }

    public float floatValue() {
        return (float)this.m_amount;
    }

    public double doubleValue() {
        return this.m_amount;
    }

    public static final MPXCurrency getInstance(MPXFile parent, String amount) throws MPXException {
        MPXNumberFormat format = parent.getCurrencyFormat();
        double value = format.parse(amount).doubleValue();
        MPXCurrency result = value == 0.0 ? parent.getZeroCurrency() : new MPXCurrency(format, value);
        return result;
    }
}

