/*
 * Decompiled with CFR 0.152.
 */
package com.tapsterrock.mpx;

import com.tapsterrock.mpx.AccrueType;
import com.tapsterrock.mpx.BookingType;
import com.tapsterrock.mpx.ExtendedAttributeContainer;
import com.tapsterrock.mpx.MPXCalendar;
import com.tapsterrock.mpx.MPXCurrency;
import com.tapsterrock.mpx.MPXDuration;
import com.tapsterrock.mpx.MPXException;
import com.tapsterrock.mpx.MPXFile;
import com.tapsterrock.mpx.MPXPercentage;
import com.tapsterrock.mpx.MPXRate;
import com.tapsterrock.mpx.MPXRecord;
import com.tapsterrock.mpx.MPXUnits;
import com.tapsterrock.mpx.Record;
import com.tapsterrock.mpx.ResourceAssignment;
import com.tapsterrock.mpx.ResourceModel;
import com.tapsterrock.mpx.ResourceNotes;
import com.tapsterrock.mpx.ResourceType;
import com.tapsterrock.mpx.TimeUnit;
import com.tapsterrock.mpx.WorkGroup;
import java.util.Date;
import java.util.LinkedList;

public final class Resource
extends MPXRecord
implements ExtendedAttributeContainer {
    private ResourceModel m_model;
    private MPXCalendar m_calendar;
    private ResourceNotes m_notes;
    private LinkedList m_assignments = new LinkedList();
    private MPXDuration m_regularWork;
    private Number m_overtimeCost;
    private Number m_actualOvertimeCost;
    private Number m_remainingOvertimeCost;
    private Date m_availableFrom;
    private Date m_availableTo;
    private ResourceType m_type;
    private boolean m_null;
    private String m_phonetics;
    private String m_ntAccount;
    private String m_materialLabel;
    private WorkGroup m_workGroup;
    private String m_hyperlink;
    private String m_hyperlinkAddress;
    private String m_hyperlinkSubAddress;
    private Date m_start;
    private Date m_finish;
    private boolean m_canLevel;
    private MPXDuration m_actualOvertimeWork;
    private MPXDuration m_remainingOvertimeWork;
    private TimeUnit m_standardRateFormat;
    private TimeUnit m_overtimeRateFormat;
    private Number m_sv;
    private Number m_cv;
    private Number m_acwp;
    private Number m_bcws;
    private Number m_bcwp;
    private boolean m_generic;
    private boolean m_inactive;
    private String m_activeDirectoryGUID;
    private MPXDuration m_actualOvertimeWorkProtected;
    private MPXDuration m_actualWorkProtected;
    private BookingType m_bookingType;
    private Date m_creationDate;
    private boolean m_enterprise;
    private Integer m_subprojectResourceUniqueID;
    private static final int PERCENT_WORK_COMPLETE = 26;
    private static final int ACCRUE_AT = 45;
    private static final int ACTUAL_COST = 32;
    private static final int ACTUAL_WORK = 22;
    private static final int BASE_CALENDAR = 48;
    private static final int BASELINE_COST = 31;
    private static final int BASELINE_WORK = 21;
    private static final int CODE = 4;
    private static final int COST = 30;
    private static final int COST_PER_USE = 44;
    private static final int COST_VARIANCE = 34;
    private static final int EMAIL_ADDRESS = 11;
    private static final int GROUP = 3;
    private static final int ID = 40;
    private static final int INITIALS = 2;
    private static final int LINKED_FIELDS = 51;
    private static final int MAX_UNITS = 41;
    private static final int NAME = 1;
    private static final int OBJECTS = 50;
    private static final int OVERALLOCATED = 46;
    private static final int OVERTIME_RATE = 43;
    private static final int OVERTIME_WORK = 24;
    private static final int PEAK_UNITS = 47;
    private static final int REMAINING_COST = 33;
    private static final int REMAINING_WORK = 23;
    private static final int STANDARD_RATE = 42;
    public static final int TEXT1 = 5;
    public static final int TEXT2 = 6;
    public static final int TEXT3 = 7;
    public static final int TEXT4 = 8;
    public static final int TEXT5 = 9;
    private static final int UNIQUE_ID = 49;
    private static final int WORK = 20;
    private static final int WORK_VARIANCE = 25;
    static final int MAX_FIELDS = 52;
    private static final int MAX_EXTENDED_FIELDS = 125;
    public static final int TEXT6 = 1000;
    public static final int TEXT7 = 1001;
    public static final int TEXT8 = 1002;
    public static final int TEXT9 = 1003;
    public static final int TEXT10 = 1004;
    public static final int TEXT11 = 1005;
    public static final int TEXT12 = 1006;
    public static final int TEXT13 = 1007;
    public static final int TEXT14 = 1008;
    public static final int TEXT15 = 1009;
    public static final int TEXT16 = 1010;
    public static final int TEXT17 = 1011;
    public static final int TEXT18 = 1012;
    public static final int TEXT19 = 1013;
    public static final int TEXT20 = 1014;
    public static final int TEXT21 = 1015;
    public static final int TEXT22 = 1016;
    public static final int TEXT23 = 1017;
    public static final int TEXT24 = 1018;
    public static final int TEXT25 = 1019;
    public static final int TEXT26 = 1020;
    public static final int TEXT27 = 1021;
    public static final int TEXT28 = 1022;
    public static final int TEXT29 = 1023;
    public static final int TEXT30 = 1024;
    public static final int START1 = 1025;
    public static final int START2 = 1026;
    public static final int START3 = 1027;
    public static final int START4 = 1028;
    public static final int START5 = 1029;
    public static final int START6 = 1030;
    public static final int START7 = 1031;
    public static final int START8 = 1032;
    public static final int START9 = 1033;
    public static final int START10 = 1034;
    public static final int FINISH1 = 1035;
    public static final int FINISH2 = 1036;
    public static final int FINISH3 = 1037;
    public static final int FINISH4 = 1038;
    public static final int FINISH5 = 1039;
    public static final int FINISH6 = 1040;
    public static final int FINISH7 = 1041;
    public static final int FINISH8 = 1042;
    public static final int FINISH9 = 1043;
    public static final int FINISH10 = 1044;
    public static final int COST1 = 1045;
    public static final int COST2 = 1046;
    public static final int COST3 = 1047;
    public static final int COST4 = 1048;
    public static final int COST5 = 1049;
    public static final int COST6 = 1050;
    public static final int COST7 = 1051;
    public static final int COST8 = 1052;
    public static final int COST9 = 1053;
    public static final int COST10 = 1054;
    public static final int DATE1 = 1055;
    public static final int DATE2 = 1056;
    public static final int DATE3 = 1057;
    public static final int DATE4 = 1058;
    public static final int DATE5 = 1059;
    public static final int DATE6 = 1060;
    public static final int DATE7 = 1061;
    public static final int DATE8 = 1062;
    public static final int DATE9 = 1063;
    public static final int DATE10 = 1064;
    public static final int FLAG1 = 1065;
    public static final int FLAG2 = 1066;
    public static final int FLAG3 = 1067;
    public static final int FLAG4 = 1068;
    public static final int FLAG5 = 1069;
    public static final int FLAG6 = 1070;
    public static final int FLAG7 = 1071;
    public static final int FLAG8 = 1072;
    public static final int FLAG9 = 1073;
    public static final int FLAG10 = 1074;
    public static final int FLAG11 = 1075;
    public static final int FLAG12 = 1076;
    public static final int FLAG13 = 1077;
    public static final int FLAG14 = 1078;
    public static final int FLAG15 = 1079;
    public static final int FLAG16 = 1080;
    public static final int FLAG17 = 1081;
    public static final int FLAG18 = 1082;
    public static final int FLAG19 = 1083;
    public static final int FLAG20 = 1084;
    public static final int NUMBER1 = 1085;
    public static final int NUMBER2 = 1086;
    public static final int NUMBER3 = 1087;
    public static final int NUMBER4 = 1088;
    public static final int NUMBER5 = 1089;
    public static final int NUMBER6 = 1090;
    public static final int NUMBER7 = 1091;
    public static final int NUMBER8 = 1092;
    public static final int NUMBER9 = 1093;
    public static final int NUMBER10 = 1094;
    public static final int NUMBER11 = 1095;
    public static final int NUMBER12 = 1096;
    public static final int NUMBER13 = 1097;
    public static final int NUMBER14 = 1098;
    public static final int NUMBER15 = 1099;
    public static final int NUMBER16 = 1100;
    public static final int NUMBER17 = 1101;
    public static final int NUMBER18 = 1102;
    public static final int NUMBER19 = 1103;
    public static final int NUMBER20 = 1104;
    public static final int DURATION1 = 1105;
    public static final int DURATION2 = 1106;
    public static final int DURATION3 = 1107;
    public static final int DURATION4 = 1108;
    public static final int DURATION5 = 1109;
    public static final int DURATION6 = 1110;
    public static final int DURATION7 = 1111;
    public static final int DURATION8 = 1112;
    public static final int DURATION9 = 1113;
    public static final int DURATION10 = 1114;
    public static final int OUTLINECODE1 = 1115;
    public static final int OUTLINECODE2 = 1116;
    public static final int OUTLINECODE3 = 1117;
    public static final int OUTLINECODE4 = 1118;
    public static final int OUTLINECODE5 = 1119;
    public static final int OUTLINECODE6 = 1120;
    public static final int OUTLINECODE7 = 1121;
    public static final int OUTLINECODE8 = 1122;
    public static final int OUTLINECODE9 = 1123;
    public static final int OUTLINECODE10 = 1124;
    static final int RECORD_NUMBER = 50;

    Resource(MPXFile file) throws MPXException {
        this(file, Record.EMPTY_RECORD);
    }

    Resource(MPXFile file, Record record) throws MPXException {
        super(file, 52, 125);
        int x;
        this.m_model = this.getParentFile().getResourceModel();
        int i = 0;
        int length = record.getLength();
        int[] model = this.m_model.getModel();
        block12: while (i < length && (x = model[i]) != -1) {
            String field;
            if ((field = record.getString(i++)) == null || field.length() == 0) continue;
            switch (x) {
                case 50: {
                    this.set(x, Integer.valueOf(field));
                    continue block12;
                }
                case 40: {
                    this.setID(Integer.valueOf(field));
                    continue block12;
                }
                case 49: {
                    this.setUniqueID(Integer.valueOf(field));
                    continue block12;
                }
                case 41: {
                    this.set(x, new MPXUnits(field, this.getParentFile().getUnitsDecimalFormat()));
                    continue block12;
                }
                case 26: 
                case 47: {
                    this.set(x, MPXPercentage.getInstance(field, this.getParentFile().getPercentageDecimalFormat()));
                    continue block12;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 44: {
                    this.set(x, MPXCurrency.getInstance(this.getParentFile(), field));
                    continue block12;
                }
                case 42: 
                case 43: {
                    this.set(x, new MPXRate(this.getParentFile().getCurrencyFormat(), field, this.getParentFile().getLocale()));
                    continue block12;
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    this.set(x, MPXDuration.getInstance(field, this.getParentFile().getDurationDecimalFormat(), this.getParentFile().getLocale()));
                    continue block12;
                }
                case 45: {
                    this.set(x, AccrueType.getInstance(field, this.getParentFile().getLocale()));
                    continue block12;
                }
                case 46: {
                    this.set(x, field.equals("No") ? Boolean.FALSE : Boolean.TRUE);
                    continue block12;
                }
            }
            this.set(x, field);
        }
        if (file.getAutoResourceUniqueID()) {
            this.setUniqueID(file.getResourceUniqueID());
        }
        if (file.getAutoResourceID()) {
            this.setID(file.getResourceID());
        }
    }

    public void setName(String val) {
        this.set(1, val);
    }

    public String getName() {
        return (String)this.get(1);
    }

    public void setType(ResourceType type) {
        this.m_type = type;
    }

    public ResourceType getType() {
        return this.m_type;
    }

    public void setIsNull(boolean isNull) {
        this.m_null = isNull;
    }

    public boolean getNull() {
        return this.m_null;
    }

    public void setInitials(String val) {
        this.set(2, val);
    }

    public String getInitials() {
        return (String)this.get(2);
    }

    public void setPhonetics(String phonetics) {
        this.m_phonetics = phonetics;
    }

    public String getPhonetics() {
        return this.m_phonetics;
    }

    public void setNtAccount(String ntAccount) {
        this.m_ntAccount = ntAccount;
    }

    public String getNtAccount() {
        return this.m_ntAccount;
    }

    public void setMaterialLabel(String materialLabel) {
        this.m_materialLabel = materialLabel;
    }

    public String getMaterialLabel() {
        return this.m_materialLabel;
    }

    public void setCode(String val) {
        this.set(4, val);
    }

    public String getCode() {
        return (String)this.get(4);
    }

    public void setGroup(String val) {
        this.set(3, val);
    }

    public String getGroup() {
        return (String)this.get(3);
    }

    public void setWorkGroup(WorkGroup workGroup) {
        this.m_workGroup = workGroup;
    }

    public WorkGroup getWorkGroup() {
        return this.m_workGroup;
    }

    public void setEmailAddress(String emailAddress) {
        this.set(11, emailAddress);
    }

    public String getEmailAddress() {
        return (String)this.get(11);
    }

    public void setHyperlink(String hyperlink) {
        this.m_hyperlink = hyperlink;
    }

    public String getHyperlink() {
        return this.m_hyperlink;
    }

    public void setHyperlinkAddress(String hyperlinkAddress) {
        this.m_hyperlinkAddress = hyperlinkAddress;
    }

    public String getHyperlinkAddress() {
        return this.m_hyperlinkAddress;
    }

    public void setHyperlinkSubAddress(String hyperlinkSubAddress) {
        this.m_hyperlinkSubAddress = hyperlinkSubAddress;
    }

    public String getHyperlinkSubAddress() {
        return this.m_hyperlinkSubAddress;
    }

    public void setMaxUnits(Number maxUnits) {
        this.setUnits(41, maxUnits);
    }

    public Number getMaxUnits() {
        return (Number)this.get(41);
    }

    public void setPeakUnits(Number peakUnits) {
        this.setPercentage(47, peakUnits);
    }

    public Number getPeakUnits() {
        return (Number)this.get(47);
    }

    public void setOverAllocated(boolean overallocated) {
        this.set(46, overallocated);
    }

    public boolean getOverAllocated() {
        return this.getBooleanValue(46);
    }

    public Date getAvailableFrom() {
        return this.m_availableFrom;
    }

    public void setAvailableFrom(Date date) {
        this.m_availableFrom = date;
    }

    public Date getAvailableTo() {
        return this.m_availableTo;
    }

    public void setAvailableTo(Date date) {
        this.m_availableTo = date;
    }

    public void setStart(Date start) {
        this.m_start = start;
    }

    public Date getStart() {
        return this.m_start;
    }

    public void setFinish(Date finish) {
        this.m_finish = finish;
    }

    public Date getFinish() {
        return this.m_finish;
    }

    public void setCanLevel(boolean canLevel) {
        this.m_canLevel = canLevel;
    }

    public boolean getCanLevel() {
        return this.m_canLevel;
    }

    public void setAccrueAt(AccrueType type) {
        this.set(45, type);
    }

    public AccrueType getAccrueAt() {
        return (AccrueType)this.get(45);
    }

    public void setWork(MPXDuration val) {
        this.set(20, val);
    }

    public MPXDuration getWork() {
        return (MPXDuration)this.get(20);
    }

    public MPXDuration getRegularWork() {
        return this.m_regularWork;
    }

    public void setRegularWork(MPXDuration duration) {
        this.m_regularWork = duration;
    }

    public void setActualWork(MPXDuration val) {
        this.set(22, val);
    }

    public MPXDuration getActualWork() {
        return (MPXDuration)this.get(22);
    }

    public void setOvertimeWork(MPXDuration overtimeWork) {
        this.set(24, overtimeWork);
    }

    public MPXDuration getOvertimeWork() {
        return (MPXDuration)this.get(24);
    }

    public void setRemainingWork(MPXDuration val) {
        this.set(23, val);
    }

    public MPXDuration getRemainingWork() {
        return (MPXDuration)this.get(23);
    }

    public MPXDuration getActualOvertimeWork() {
        return this.m_actualOvertimeWork;
    }

    public void setActualOvertimeWork(MPXDuration duration) {
        this.m_actualOvertimeWork = duration;
    }

    public MPXDuration getRemainingOvertimeWork() {
        return this.m_remainingOvertimeWork;
    }

    public void setRemainingOvertimeWork(MPXDuration duration) {
        this.m_remainingOvertimeWork = duration;
    }

    public void setPercentWorkComplete(Number percentWorkComplete) {
        this.setPercentage(26, percentWorkComplete);
    }

    public Number getPercentWorkComplete() {
        return (Number)this.get(26);
    }

    public void setStandardRate(MPXRate val) {
        this.set(42, val);
    }

    public MPXRate getStandardRate() {
        return (MPXRate)this.get(42);
    }

    public void setStandardRateFormat(TimeUnit format) {
        this.m_standardRateFormat = format;
    }

    public TimeUnit getStandardRateFormat() {
        return this.m_standardRateFormat;
    }

    public void setCost(Number cost) {
        this.setCurrency(30, cost);
    }

    public Number getCost() {
        return (Number)this.get(30);
    }

    public void setOvertimeRate(MPXRate overtimeRate) {
        this.set(43, overtimeRate);
    }

    public MPXRate getOvertimeRate() {
        return (MPXRate)this.get(43);
    }

    public void setOvertimeRateFormat(TimeUnit format) {
        this.m_overtimeRateFormat = format;
    }

    public TimeUnit getOvertimeRateFormat() {
        return this.m_overtimeRateFormat;
    }

    public Number getOvertimeCost() {
        return this.m_overtimeCost;
    }

    public void setOvertimeCost(Number currency) {
        this.m_overtimeCost = currency;
    }

    public void setCostPerUse(Number costPerUse) {
        this.setCurrency(44, costPerUse);
    }

    public Number getCostPerUse() {
        return (Number)this.get(44);
    }

    public void setActualCost(Number actualCost) {
        this.setCurrency(32, actualCost);
    }

    public Number getActualCost() {
        return (Number)this.get(32);
    }

    public Number getActualOvertimeCost() {
        return this.m_actualOvertimeCost;
    }

    public void setActualOvertimeCost(Number actualOvertimeCost) {
        this.m_actualOvertimeCost = actualOvertimeCost;
    }

    public void setRemainingCost(Number remainingCost) {
        this.setCurrency(33, remainingCost);
    }

    public Number getRemainingCost() {
        return (Number)this.get(33);
    }

    public Number getRemainingOvertimeCost() {
        return this.m_remainingOvertimeCost;
    }

    public void setRemainingOvertimeCost(Number remainingOvertimeCost) {
        this.m_remainingOvertimeCost = remainingOvertimeCost;
    }

    public void setWorkVariance(MPXDuration workVariance) {
        this.set(25, workVariance);
    }

    public MPXDuration getWorkVariance() {
        return (MPXDuration)this.get(25);
    }

    public void setCostVariance(Number costVariance) {
        this.setCurrency(34, costVariance);
    }

    public Number getCostVariance() {
        return (Number)this.get(34);
    }

    public void setSV(Number sv) {
        this.m_sv = sv;
    }

    public Number getSV() {
        return this.m_sv;
    }

    public void setCV(Number cv) {
        this.m_cv = cv;
    }

    public Number getCV() {
        return this.m_cv;
    }

    public void setACWP(Number acwp) {
        this.m_acwp = acwp;
    }

    public Number getACWP() {
        return this.m_acwp;
    }

    public void setNotes(String notes) {
        if (this.m_notes == null) {
            this.m_notes = new ResourceNotes(this.getParentFile());
        }
        if (notes == null) {
            notes = "";
        }
        this.m_notes.setNotes(notes);
    }

    public String getNotes() {
        String result = this.m_notes != null ? this.m_notes.getNotes() : "";
        return result;
    }

    public void setBCWS(Number bcws) {
        this.m_bcws = bcws;
    }

    public Number getBCWS() {
        return this.m_bcws;
    }

    public void setBCWP(Number bcwp) {
        this.m_bcwp = bcwp;
    }

    public Number getBCWP() {
        return this.m_bcwp;
    }

    public void setIsGeneric(boolean isGeneric) {
        this.m_generic = isGeneric;
    }

    public boolean getGeneric() {
        return this.m_generic;
    }

    public void setIsInactive(boolean isInactive) {
        this.m_inactive = isInactive;
    }

    public boolean getInactive() {
        return this.m_inactive;
    }

    public void setActveDirectoryGUID(String guid) {
        this.m_activeDirectoryGUID = guid;
    }

    public String getActiveDirectoryGUID() {
        return this.m_activeDirectoryGUID;
    }

    public void setActualOvertimeWorkProtected(MPXDuration duration) {
        this.m_actualOvertimeWorkProtected = duration;
    }

    public MPXDuration getActualOvertimeWorkProtected() {
        return this.m_actualOvertimeWorkProtected;
    }

    public void setActualWorkProtected(MPXDuration duration) {
        this.m_actualWorkProtected = duration;
    }

    public MPXDuration getActualWorkProtected() {
        return this.m_actualWorkProtected;
    }

    public void setBookingType(BookingType bookingType) {
        this.m_bookingType = bookingType;
    }

    public BookingType getBookingType() {
        return this.m_bookingType;
    }

    public void setCreationDate(Date creationDate) {
        this.m_creationDate = creationDate;
    }

    public Date getCreationDate() {
        return this.m_creationDate;
    }

    public void setIsEnterprise(boolean enterprise) {
        this.m_enterprise = enterprise;
    }

    public boolean getEnterprise() {
        return this.m_enterprise;
    }

    ResourceNotes addResourceNotes(Record record) throws MPXException {
        if (this.m_notes != null) {
            throw new MPXException("Maximum number of records of this type exist");
        }
        this.m_notes = new ResourceNotes(this.getParentFile(), record);
        return this.m_notes;
    }

    public MPXCalendar getResourceCalendar() {
        return this.m_calendar;
    }

    void attachResourceCalendar(MPXCalendar calendar) {
        this.m_calendar = calendar;
    }

    public MPXCalendar addResourceCalendar() throws MPXException {
        if (this.m_calendar != null) {
            throw new MPXException("Maximum number of records of this type exist");
        }
        this.m_calendar = new MPXCalendar(this.getParentFile(), false);
        return this.m_calendar;
    }

    MPXCalendar addResourceCalendar(Record record) throws MPXException {
        if (this.m_calendar != null) {
            throw new MPXException("Maximum number of records of this type exist");
        }
        this.m_calendar = new MPXCalendar(this.getParentFile(), record, false);
        return this.m_calendar;
    }

    public void set(int field, Object val) {
        this.m_model.add(field);
        this.put(field, val);
    }

    private void set(int field, int val) {
        this.m_model.add(field);
        this.put(field, val);
    }

    public void setDate(int field, Date val) {
        this.putDate(field, val);
    }

    private void set(int field, boolean val) {
        this.put(field, val);
    }

    public void setCurrency(int field, Number val) {
        this.m_model.add(field);
        this.putCurrency(field, val);
    }

    private void setUnits(int field, Number val) {
        this.m_model.add(field);
        this.putUnits(field, val);
    }

    private void setPercentage(int field, Number val) {
        this.m_model.add(field);
        this.putPercentage(field, val);
    }

    public void setBaseCalendar(String val) {
        this.set(48, val == null || val.length() == 0 ? "Standard" : val);
    }

    public void setBaselineCost(Number val) {
        this.setCurrency(31, val);
    }

    public void setBaselineWork(MPXDuration val) {
        this.set(21, val);
    }

    public void setID(int val) {
        this.setID(new Integer(val));
    }

    public void setID(Integer val) {
        MPXFile parent = this.getParentFile();
        Integer previous = this.getID();
        if (previous != null) {
            parent.unmapResourceID(previous);
        }
        parent.mapResourceID(val, this);
        this.set(40, val);
    }

    public void setLinkedFields(String val) {
        this.set(51, val);
    }

    public void setObjects(int val) {
        this.set(50, val);
    }

    public void setText1(String val) {
        this.set(5, val);
    }

    public void setText2(String val) {
        this.set(6, val);
    }

    public void setText3(String val) {
        this.set(7, val);
    }

    public void setText4(String val) {
        this.set(8, val);
    }

    public void setText5(String val) {
        this.set(9, val);
    }

    public void setUniqueID(int val) {
        this.setUniqueID(new Integer(val));
    }

    public void setUniqueID(Integer val) {
        MPXFile parent = this.getParentFile();
        Integer previous = this.getUniqueID();
        if (previous != null) {
            parent.unmapResourceUniqueID(previous);
        }
        parent.mapResourceUniqueID(val, this);
        this.set(49, val);
    }

    public String getBaseCalendar() {
        return (String)this.get(48);
    }

    public Number getBaselineCost() {
        return (Number)this.get(31);
    }

    public MPXDuration getBaselineWork() {
        return (MPXDuration)this.get(21);
    }

    public int getIDValue() {
        return this.getIntValue(40);
    }

    public Integer getID() {
        return (Integer)this.get(40);
    }

    public String getLinkedFields() {
        return (String)this.get(51);
    }

    public int getObjectsValue() {
        return this.getIntValue(50);
    }

    public Integer getObjects() {
        return (Integer)this.get(50);
    }

    public String getText1() {
        return (String)this.get(5);
    }

    public String getText2() {
        return (String)this.get(6);
    }

    public String getText3() {
        return (String)this.get(7);
    }

    public String getText4() {
        return (String)this.get(8);
    }

    public String getText5() {
        return (String)this.get(9);
    }

    public int getUniqueIDValue() {
        return this.getIntValue(49);
    }

    public Integer getUniqueID() {
        return (Integer)this.get(49);
    }

    public String getText6() {
        return (String)this.get(1000);
    }

    public String getText7() {
        return (String)this.get(1001);
    }

    public String getText8() {
        return (String)this.get(1002);
    }

    public String getText9() {
        return (String)this.get(1003);
    }

    public String getText10() {
        return (String)this.get(1004);
    }

    public String getText11() {
        return (String)this.get(1005);
    }

    public String getText12() {
        return (String)this.get(1006);
    }

    public String getText13() {
        return (String)this.get(1007);
    }

    public String getText14() {
        return (String)this.get(1008);
    }

    public String getText15() {
        return (String)this.get(1009);
    }

    public String getText16() {
        return (String)this.get(1010);
    }

    public String getText17() {
        return (String)this.get(1011);
    }

    public String getText18() {
        return (String)this.get(1012);
    }

    public String getText19() {
        return (String)this.get(1013);
    }

    public String getText20() {
        return (String)this.get(1014);
    }

    public String getText21() {
        return (String)this.get(1015);
    }

    public String getText22() {
        return (String)this.get(1016);
    }

    public String getText23() {
        return (String)this.get(1017);
    }

    public String getText24() {
        return (String)this.get(1018);
    }

    public String getText25() {
        return (String)this.get(1019);
    }

    public String getText26() {
        return (String)this.get(1020);
    }

    public String getText27() {
        return (String)this.get(1021);
    }

    public String getText28() {
        return (String)this.get(1022);
    }

    public String getText29() {
        return (String)this.get(1023);
    }

    public String getText30() {
        return (String)this.get(1024);
    }

    public void setText6(String string) {
        this.set(1000, string);
    }

    public void setText7(String string) {
        this.set(1001, string);
    }

    public void setText8(String string) {
        this.set(1002, string);
    }

    public void setText9(String string) {
        this.set(1003, string);
    }

    public void setText10(String string) {
        this.set(1004, string);
    }

    public void setText11(String string) {
        this.set(1005, string);
    }

    public void setText12(String string) {
        this.set(1006, string);
    }

    public void setText13(String string) {
        this.set(1007, string);
    }

    public void setText14(String string) {
        this.set(1008, string);
    }

    public void setText15(String string) {
        this.set(1009, string);
    }

    public void setText16(String string) {
        this.set(1010, string);
    }

    public void setText17(String string) {
        this.set(1011, string);
    }

    public void setText18(String string) {
        this.set(1012, string);
    }

    public void setText19(String string) {
        this.set(1013, string);
    }

    public void setText20(String string) {
        this.set(1014, string);
    }

    public void setText21(String string) {
        this.set(1015, string);
    }

    public void setText22(String string) {
        this.set(1016, string);
    }

    public void setText23(String string) {
        this.set(1017, string);
    }

    public void setText24(String string) {
        this.set(1018, string);
    }

    public void setText25(String string) {
        this.set(1019, string);
    }

    public void setText26(String string) {
        this.set(1020, string);
    }

    public void setText27(String string) {
        this.set(1021, string);
    }

    public void setText28(String string) {
        this.set(1022, string);
    }

    public void setText29(String string) {
        this.set(1023, string);
    }

    public void setText30(String string) {
        this.set(1024, string);
    }

    public Date getStart1() {
        return (Date)this.get(1025);
    }

    public Date getStart2() {
        return (Date)this.get(1026);
    }

    public Date getStart3() {
        return (Date)this.get(1027);
    }

    public Date getStart4() {
        return (Date)this.get(1028);
    }

    public Date getStart5() {
        return (Date)this.get(1029);
    }

    public Date getStart6() {
        return (Date)this.get(1030);
    }

    public Date getStart7() {
        return (Date)this.get(1031);
    }

    public Date getStart8() {
        return (Date)this.get(1032);
    }

    public Date getStart9() {
        return (Date)this.get(1033);
    }

    public Date getStart10() {
        return (Date)this.get(1034);
    }

    public void setStart1(Date date) {
        this.setDate(1025, date);
    }

    public void setStart2(Date date) {
        this.setDate(1026, date);
    }

    public void setStart3(Date date) {
        this.setDate(1027, date);
    }

    public void setStart4(Date date) {
        this.setDate(1028, date);
    }

    public void setStart5(Date date) {
        this.setDate(1029, date);
    }

    public void setStart6(Date date) {
        this.setDate(1030, date);
    }

    public void setStart7(Date date) {
        this.setDate(1031, date);
    }

    public void setStart8(Date date) {
        this.setDate(1032, date);
    }

    public void setStart9(Date date) {
        this.setDate(1033, date);
    }

    public void setStart10(Date date) {
        this.setDate(1034, date);
    }

    public Date getFinish1() {
        return (Date)this.get(1035);
    }

    public Date getFinish2() {
        return (Date)this.get(1036);
    }

    public Date getFinish3() {
        return (Date)this.get(1037);
    }

    public Date getFinish4() {
        return (Date)this.get(1038);
    }

    public Date getFinish5() {
        return (Date)this.get(1039);
    }

    public Date getFinish6() {
        return (Date)this.get(1040);
    }

    public Date getFinish7() {
        return (Date)this.get(1041);
    }

    public Date getFinish8() {
        return (Date)this.get(1042);
    }

    public Date getFinish9() {
        return (Date)this.get(1043);
    }

    public Date getFinish10() {
        return (Date)this.get(1044);
    }

    public void setFinish1(Date date) {
        this.setDate(1035, date);
    }

    public void setFinish2(Date date) {
        this.setDate(1036, date);
    }

    public void setFinish3(Date date) {
        this.setDate(1037, date);
    }

    public void setFinish4(Date date) {
        this.setDate(1038, date);
    }

    public void setFinish5(Date date) {
        this.setDate(1039, date);
    }

    public void setFinish6(Date date) {
        this.setDate(1040, date);
    }

    public void setFinish7(Date date) {
        this.setDate(1041, date);
    }

    public void setFinish8(Date date) {
        this.setDate(1042, date);
    }

    public void setFinish9(Date date) {
        this.setDate(1043, date);
    }

    public void setFinish10(Date date) {
        this.setDate(1044, date);
    }

    public void setNumber1(Double val) {
        this.set(1085, val);
    }

    public double getNumber1Value() {
        return this.getDoubleValue(1085);
    }

    public Double getNumber1() {
        return (Double)this.get(1085);
    }

    public void setNumber2(Double val) {
        this.set(1086, val);
    }

    public double getNumber2Value() {
        return this.getDoubleValue(1086);
    }

    public Double getNumber2() {
        return (Double)this.get(1086);
    }

    public void setNumber3(Double val) {
        this.set(1087, val);
    }

    public double getNumber3Value() {
        return this.getDoubleValue(1087);
    }

    public Double getNumber3() {
        return (Double)this.get(1087);
    }

    public void setNumber4(Double val) {
        this.set(1088, val);
    }

    public double getNumber4Value() {
        return this.getDoubleValue(1088);
    }

    public Double getNumber4() {
        return (Double)this.get(1098);
    }

    public void setNumber5(Double val) {
        this.set(1089, val);
    }

    public double getNumber5Value() {
        return this.getDoubleValue(1089);
    }

    public Double getNumber5() {
        return (Double)this.get(1089);
    }

    public void setNumber6(Double val) {
        this.set(1090, val);
    }

    public double getNumber6Value() {
        return this.getDoubleValue(1090);
    }

    public Double getNumber6() {
        return (Double)this.get(1090);
    }

    public void setNumber7(Double val) {
        this.set(1091, val);
    }

    public double getNumber7Value() {
        return this.getDoubleValue(1091);
    }

    public Double getNumber7() {
        return (Double)this.get(1091);
    }

    public void setNumber8(Double val) {
        this.set(1092, val);
    }

    public double getNumber8Value() {
        return this.getDoubleValue(1092);
    }

    public Double getNumber8() {
        return (Double)this.get(1092);
    }

    public void setNumber9(Double val) {
        this.set(1093, val);
    }

    public double getNumber9Value() {
        return this.getDoubleValue(1093);
    }

    public Double getNumber9() {
        return (Double)this.get(1093);
    }

    public void setNumber10(Double val) {
        this.set(1094, val);
    }

    public double getNumber10Value() {
        return this.getDoubleValue(1094);
    }

    public Double getNumber10() {
        return (Double)this.get(1094);
    }

    public void setNumber11(Double val) {
        this.set(1095, val);
    }

    public double getNumber11Value() {
        return this.getDoubleValue(1095);
    }

    public Double getNumber11() {
        return (Double)this.get(1095);
    }

    public void setNumber12(Double val) {
        this.set(1096, val);
    }

    public double getNumber12Value() {
        return this.getDoubleValue(1096);
    }

    public Double getNumber12() {
        return (Double)this.get(1096);
    }

    public void setNumber13(Double val) {
        this.set(1097, val);
    }

    public double getNumber13Value() {
        return this.getDoubleValue(1097);
    }

    public Double getNumber13() {
        return (Double)this.get(1097);
    }

    public void setNumber14(Double val) {
        this.set(1098, val);
    }

    public double getNumber14Value() {
        return this.getDoubleValue(1098);
    }

    public Double getNumber14() {
        return (Double)this.get(1098);
    }

    public void setNumber15(Double val) {
        this.set(1099, val);
    }

    public double getNumber15Value() {
        return this.getDoubleValue(1099);
    }

    public Double getNumber15() {
        return (Double)this.get(1099);
    }

    public void setNumber16(Double val) {
        this.set(1100, val);
    }

    public double getNumber16Value() {
        return this.getDoubleValue(1100);
    }

    public Double getNumber16() {
        return (Double)this.get(1100);
    }

    public void setNumber17(Double val) {
        this.set(1101, val);
    }

    public double getNumber17Value() {
        return this.getDoubleValue(1101);
    }

    public Double getNumber17() {
        return (Double)this.get(1101);
    }

    public void setNumber18(Double val) {
        this.set(1102, val);
    }

    public double getNumber18Value() {
        return this.getDoubleValue(1102);
    }

    public Double getNumber18() {
        return (Double)this.get(1102);
    }

    public void setNumber19(Double val) {
        this.set(1103, val);
    }

    public double getNumber19Value() {
        return this.getDoubleValue(1103);
    }

    public Double getNumber19() {
        return (Double)this.get(1103);
    }

    public void setNumber20(Double val) {
        this.set(1104, val);
    }

    public double getNumber20Value() {
        return this.getDoubleValue(1104);
    }

    public Double getNumber20() {
        return (Double)this.get(1104);
    }

    public MPXDuration getDuration1() {
        return (MPXDuration)this.get(1105);
    }

    public MPXDuration getDuration2() {
        return (MPXDuration)this.get(1106);
    }

    public MPXDuration getDuration3() {
        return (MPXDuration)this.get(1107);
    }

    public MPXDuration getDuration4() {
        return (MPXDuration)this.get(1108);
    }

    public MPXDuration getDuration5() {
        return (MPXDuration)this.get(1109);
    }

    public MPXDuration getDuration6() {
        return (MPXDuration)this.get(1110);
    }

    public MPXDuration getDuration7() {
        return (MPXDuration)this.get(1111);
    }

    public MPXDuration getDuration8() {
        return (MPXDuration)this.get(1112);
    }

    public MPXDuration getDuration9() {
        return (MPXDuration)this.get(1113);
    }

    public MPXDuration getDuration10() {
        return (MPXDuration)this.get(1114);
    }

    public void setDuration1(MPXDuration duration) {
        this.set(1105, duration);
    }

    public void setDuration2(MPXDuration duration) {
        this.set(1106, duration);
    }

    public void setDuration3(MPXDuration duration) {
        this.set(1107, duration);
    }

    public void setDuration4(MPXDuration duration) {
        this.set(1108, duration);
    }

    public void setDuration5(MPXDuration duration) {
        this.set(1109, duration);
    }

    public void setDuration6(MPXDuration duration) {
        this.set(1110, duration);
    }

    public void setDuration7(MPXDuration duration) {
        this.set(1111, duration);
    }

    public void setDuration8(MPXDuration duration) {
        this.set(1112, duration);
    }

    public void setDuration9(MPXDuration duration) {
        this.set(1113, duration);
    }

    public void setDuration10(MPXDuration duration) {
        this.set(1114, duration);
    }

    public Date getDate1() {
        return (Date)this.get(1055);
    }

    public Date getDate10() {
        return (Date)this.get(1064);
    }

    public Date getDate2() {
        return (Date)this.get(1056);
    }

    public Date getDate3() {
        return (Date)this.get(1057);
    }

    public Date getDate4() {
        return (Date)this.get(1058);
    }

    public Date getDate5() {
        return (Date)this.get(1059);
    }

    public Date getDate6() {
        return (Date)this.get(1060);
    }

    public Date getDate7() {
        return (Date)this.get(1061);
    }

    public Date getDate8() {
        return (Date)this.get(1062);
    }

    public Date getDate9() {
        return (Date)this.get(1063);
    }

    public void setDate1(Date date) {
        this.setDate(1055, date);
    }

    public void setDate10(Date date) {
        this.setDate(1064, date);
    }

    public void setDate2(Date date) {
        this.setDate(1056, date);
    }

    public void setDate3(Date date) {
        this.setDate(1057, date);
    }

    public void setDate4(Date date) {
        this.setDate(1058, date);
    }

    public void setDate5(Date date) {
        this.setDate(1059, date);
    }

    public void setDate6(Date date) {
        this.setDate(1060, date);
    }

    public void setDate7(Date date) {
        this.setDate(1061, date);
    }

    public void setDate8(Date date) {
        this.setDate(1062, date);
    }

    public void setDate9(Date date) {
        this.setDate(1063, date);
    }

    public Number getCost1() {
        return (Number)this.get(1045);
    }

    public Number getCost2() {
        return (Number)this.get(1046);
    }

    public Number getCost3() {
        return (Number)this.get(1047);
    }

    public Number getCost4() {
        return (Number)this.get(1048);
    }

    public Number getCost5() {
        return (Number)this.get(1049);
    }

    public Number getCost6() {
        return (Number)this.get(1050);
    }

    public Number getCost7() {
        return (Number)this.get(1051);
    }

    public Number getCost8() {
        return (Number)this.get(1052);
    }

    public Number getCost9() {
        return (Number)this.get(1053);
    }

    public Number getCost10() {
        return (Number)this.get(1054);
    }

    public void setCost1(Number number) {
        this.setCurrency(1045, number);
    }

    public void setCost2(Number number) {
        this.setCurrency(1046, number);
    }

    public void setCost3(Number number) {
        this.setCurrency(1047, number);
    }

    public void setCost4(Number number) {
        this.setCurrency(1048, number);
    }

    public void setCost5(Number number) {
        this.setCurrency(1049, number);
    }

    public void setCost6(Number number) {
        this.setCurrency(1050, number);
    }

    public void setCost7(Number number) {
        this.setCurrency(1051, number);
    }

    public void setCost8(Number number) {
        this.setCurrency(1052, number);
    }

    public void setCost9(Number number) {
        this.setCurrency(1053, number);
    }

    public void setCost10(Number number) {
        this.setCurrency(1054, number);
    }

    public boolean getFlag1() {
        return this.getBooleanValue(1065);
    }

    public boolean getFlag2() {
        return this.getBooleanValue(1066);
    }

    public boolean getFlag3() {
        return this.getBooleanValue(1067);
    }

    public boolean getFlag4() {
        return this.getBooleanValue(1068);
    }

    public boolean getFlag5() {
        return this.getBooleanValue(1069);
    }

    public boolean getFlag6() {
        return this.getBooleanValue(1070);
    }

    public boolean getFlag7() {
        return this.getBooleanValue(1071);
    }

    public boolean getFlag8() {
        return this.getBooleanValue(1072);
    }

    public boolean getFlag9() {
        return this.getBooleanValue(1073);
    }

    public boolean getFlag10() {
        return this.getBooleanValue(1074);
    }

    public boolean getFlag11() {
        return this.getBooleanValue(1075);
    }

    public boolean getFlag12() {
        return this.getBooleanValue(1076);
    }

    public boolean getFlag13() {
        return this.getBooleanValue(1077);
    }

    public boolean getFlag14() {
        return this.getBooleanValue(1078);
    }

    public boolean getFlag15() {
        return this.getBooleanValue(1079);
    }

    public boolean getFlag16() {
        return this.getBooleanValue(1080);
    }

    public boolean getFlag17() {
        return this.getBooleanValue(1081);
    }

    public boolean getFlag18() {
        return this.getBooleanValue(1082);
    }

    public boolean getFlag19() {
        return this.getBooleanValue(1083);
    }

    public boolean getFlag20() {
        return this.getBooleanValue(1084);
    }

    public void setFlag1(boolean b) {
        this.set(1065, b);
    }

    public void setFlag2(boolean b) {
        this.set(1066, b);
    }

    public void setFlag3(boolean b) {
        this.set(1067, b);
    }

    public void setFlag4(boolean b) {
        this.set(1068, b);
    }

    public void setFlag5(boolean b) {
        this.set(1069, b);
    }

    public void setFlag6(boolean b) {
        this.set(1070, b);
    }

    public void setFlag7(boolean b) {
        this.set(1071, b);
    }

    public void setFlag8(boolean b) {
        this.set(1072, b);
    }

    public void setFlag9(boolean b) {
        this.set(1073, b);
    }

    public void setFlag10(boolean b) {
        this.set(1074, b);
    }

    public void setFlag11(boolean b) {
        this.set(1075, b);
    }

    public void setFlag12(boolean b) {
        this.set(1076, b);
    }

    public void setFlag13(boolean b) {
        this.set(1077, b);
    }

    public void setFlag14(boolean b) {
        this.set(1078, b);
    }

    public void setFlag15(boolean b) {
        this.set(1079, b);
    }

    public void setFlag16(boolean b) {
        this.set(1080, b);
    }

    public void setFlag17(boolean b) {
        this.set(1081, b);
    }

    public void setFlag18(boolean b) {
        this.set(1082, b);
    }

    public void setFlag19(boolean b) {
        this.set(1083, b);
    }

    public void setFlag20(boolean b) {
        this.set(1084, b);
    }

    public void setOutlineCode1(String value) {
        this.set(1115, value);
    }

    public String getOutlineCode1() {
        return (String)this.get(1115);
    }

    public void setOutlineCode2(String value) {
        this.set(1116, value);
    }

    public String getOutlineCode2() {
        return (String)this.get(1116);
    }

    public void setOutlineCode3(String value) {
        this.set(1117, value);
    }

    public String getOutlineCode3() {
        return (String)this.get(1117);
    }

    public void setOutlineCode4(String value) {
        this.set(1118, value);
    }

    public String getOutlineCode4() {
        return (String)this.get(1118);
    }

    public void setOutlineCode5(String value) {
        this.set(1119, value);
    }

    public String getOutlineCode5() {
        return (String)this.get(1119);
    }

    public void setOutlineCode6(String value) {
        this.set(1120, value);
    }

    public String getOutlineCode6() {
        return (String)this.get(1120);
    }

    public void setOutlineCode7(String value) {
        this.set(1121, value);
    }

    public String getOutlineCode7() {
        return (String)this.get(1121);
    }

    public void setOutlineCode8(String value) {
        this.set(1122, value);
    }

    public String getOutlineCode8() {
        return (String)this.get(1122);
    }

    public void setOutlineCode9(String value) {
        this.set(1123, value);
    }

    public String getOutlineCode9() {
        return (String)this.get(1123);
    }

    public void setOutlineCode10(String value) {
        this.set(1124, value);
    }

    public String getOutlineCode10() {
        return (String)this.get(1124);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (!this.m_model.getWritten()) {
            buf.append(this.m_model.toString());
            this.m_model.setWritten(true);
        }
        buf.append(this.toString(50, this.m_model.getModel()));
        if (this.m_notes != null) {
            buf.append(this.m_notes.toString());
        }
        if (this.m_calendar != null) {
            buf.append(this.m_calendar.toString());
        }
        return buf.toString();
    }

    public Object getFieldByAlias(String alias) {
        Object result = null;
        int field = this.getParentFile().getAliasResourceField(alias);
        if (field != -1) {
            result = this.get(field);
        }
        return result;
    }

    public void setFieldByAlias(String alias, Object value) {
        int field = this.getParentFile().getAliasResourceField(alias);
        if (field != -1) {
            this.set(field, value);
        }
    }

    void addAssignment(ResourceAssignment assignment) {
        this.m_assignments.add(assignment);
    }

    public LinkedList getTaskAssignments() {
        return this.m_assignments;
    }

    public Integer getSubprojectResourceUniqueID() {
        return this.m_subprojectResourceUniqueID;
    }

    public void setSubprojectResourceUniqueID(Integer subprojectUniqueResourceID) {
        this.m_subprojectResourceUniqueID = subprojectUniqueResourceID;
    }
}

