/*
 * Decompiled with CFR 0.152.
 */
package org.ganttproject.impex.htmlpdf.fonts;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.ganttproject.impex.htmlpdf.fonts.FontMetricsStorage;
import org.ganttproject.impex.htmlpdf.fonts.FontTriplet;
import org.ganttproject.impex.htmlpdf.fonts.TTFFileExt;

public class FontRecord {
    private URI myLocation;
    private URI myMetricsLocation;
    private ArrayList myTriplets = new ArrayList();
    private TTFFileExt myTTFFile;

    public FontRecord(File fontFile, FontMetricsStorage metricsStorage) throws IOException {
        this.myTTFFile = new TTFFileExt(fontFile);
        this.myLocation = fontFile.toURI();
        this.myMetricsLocation = metricsStorage.getFontMetricsURI(this.myTTFFile);
    }

    public FontRecord(URI fontLocation, URI metricsLocation) {
        this.myLocation = fontLocation;
        this.myMetricsLocation = metricsLocation;
    }

    public void addTriplet(FontTriplet triplet) {
        this.myTriplets.add(triplet);
    }

    public URI getFontLocation() {
        return this.myLocation;
    }

    public URI getMetricsLocation() {
        return this.myMetricsLocation;
    }

    public FontTriplet[] getFontTriplets() {
        return this.myTriplets.toArray(new FontTriplet[0]);
    }

    public TTFFileExt getTTFFile() {
        return this.myTTFFile;
    }

    public String toString() {
        return "font file=" + this.myLocation + " metrics file=" + this.myMetricsLocation;
    }
}

