/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.transaction.locking;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.transaction.locking.MultiLevelLock;
import org.apache.commons.transaction.util.LoggerFacade;

public class GenericLock
implements MultiLevelLock {
    public static final int COMPATIBILITY_NONE = 0;
    public static final int COMPATIBILITY_REENTRANT = 1;
    public static final int COMPATIBILITY_SUPPORT = 2;
    public static final int COMPATIBILITY_REENTRANT_AND_SUPPORT = 3;
    private Object resourceId;
    private Map owners = new HashMap();
    private int maxLockLevel;
    protected LoggerFacade logger;

    public GenericLock(Object resourceId, int maxLockLevel, LoggerFacade logger) {
        if (maxLockLevel < 1) {
            throw new IllegalArgumentException("The maximum lock level must be at least 1 (" + maxLockLevel + " was specified)");
        }
        this.resourceId = resourceId;
        this.maxLockLevel = maxLockLevel;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean test(Object ownerId, int targetLockLevel, int compatibility) {
        boolean success = false;
        try {
            success = this.tryLock(ownerId, targetLockLevel, compatibility);
        }
        finally {
            this.release(ownerId);
        }
        return success;
    }

    public synchronized boolean acquire(Object ownerId, int targetLockLevel, boolean wait, boolean reentrant, long timeoutMSecs) throws InterruptedException {
        return this.acquire(ownerId, targetLockLevel, wait, reentrant ? 1 : 0, timeoutMSecs);
    }

    public synchronized boolean acquire(Object ownerId, int targetLockLevel, boolean wait, int compatibility, long timeoutMSecs) throws InterruptedException {
        if (this.logger.isFinerEnabled()) {
            this.logger.logFiner(ownerId.toString() + " trying to acquire lock for " + this.resourceId.toString() + " at level " + targetLockLevel + " at " + System.currentTimeMillis());
        }
        if (this.tryLock(ownerId, targetLockLevel, compatibility)) {
            if (this.logger.isFinerEnabled()) {
                this.logger.logFiner(ownerId.toString() + " actually acquired lock for " + this.resourceId.toString() + " at " + System.currentTimeMillis());
            }
            return true;
        }
        if (!wait) {
            return false;
        }
        long started = System.currentTimeMillis();
        long remaining = timeoutMSecs;
        while (remaining > 0L) {
            if (this.logger.isFinerEnabled()) {
                this.logger.logFiner(ownerId.toString() + " waiting on " + this.resourceId.toString() + " for msecs " + timeoutMSecs + " at " + System.currentTimeMillis());
            }
            this.wait(remaining);
            if (this.tryLock(ownerId, targetLockLevel, compatibility)) {
                if (this.logger.isFinerEnabled()) {
                    this.logger.logFiner(ownerId.toString() + " waiting on " + this.resourceId.toString() + " eventually got the lock at " + System.currentTimeMillis());
                }
                return true;
            }
            remaining = timeoutMSecs - (System.currentTimeMillis() - started);
        }
        return false;
    }

    public synchronized void release(Object ownerId) {
        if (this.owners.remove(ownerId) != null) {
            if (this.logger.isFinerEnabled()) {
                this.logger.logFiner(ownerId.toString() + " releasing lock for " + this.resourceId.toString() + " at " + System.currentTimeMillis());
            }
            this.notifyAll();
        }
    }

    public synchronized int getLockLevel(Object ownerId) {
        LockOwner owner = (LockOwner)this.owners.get(ownerId);
        if (owner == null) {
            return 0;
        }
        return owner.lockLevel;
    }

    public Object getResourceId() {
        return this.resourceId;
    }

    public int getLevelMinLock() {
        return 0;
    }

    public int getLevelMaxLock() {
        return this.maxLockLevel;
    }

    public Object getOwner() {
        LockOwner owner = this.getMaxLevelOwner();
        if (owner == null) {
            return null;
        }
        return owner.ownerId;
    }

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.resourceId.toString()).append(":\n");
        Iterator it = this.owners.values().iterator();
        while (it.hasNext()) {
            LockOwner owner = (LockOwner)it.next();
            buf.append("- ").append(owner.ownerId.toString()).append(": ").append(owner.lockLevel).append("\n");
        }
        return buf.toString();
    }

    protected synchronized LockOwner getMaxLevelOwner() {
        return this.getMaxLevelOwner(null, -1);
    }

    protected synchronized LockOwner getMaxLevelOwner(LockOwner reentrantOwner) {
        return this.getMaxLevelOwner(reentrantOwner, -1);
    }

    protected synchronized LockOwner getMaxLevelOwner(int supportLockLevel) {
        return this.getMaxLevelOwner(null, supportLockLevel);
    }

    protected synchronized LockOwner getMaxLevelOwner(LockOwner reentrantOwner, int supportLockLevel) {
        LockOwner maxOwner = null;
        Iterator it = this.owners.values().iterator();
        while (it.hasNext()) {
            LockOwner owner = (LockOwner)it.next();
            if (owner.lockLevel == supportLockLevel || owner.equals(reentrantOwner) || maxOwner != null && maxOwner.lockLevel >= owner.lockLevel) continue;
            maxOwner = owner;
        }
        return maxOwner;
    }

    protected synchronized void setLockLevel(Object ownerId, LockOwner lock, int targetLockLevel) {
        if (lock != null) {
            if (this.logger.isFinestEnabled()) {
                this.logger.logFinest(ownerId.toString() + " upgrading lock for " + this.resourceId.toString() + " to level " + targetLockLevel + " at " + System.currentTimeMillis());
            }
            lock.lockLevel = targetLockLevel;
        } else {
            if (this.logger.isFinestEnabled()) {
                this.logger.logFinest(ownerId.toString() + " getting new lock for " + this.resourceId.toString() + " at level " + targetLockLevel + " at " + System.currentTimeMillis());
            }
            this.owners.put(ownerId, new LockOwner(ownerId, targetLockLevel));
        }
    }

    protected synchronized boolean tryLock(Object ownerId, int targetLockLevel, int compatibility) {
        LockOwner highestOwner;
        LockOwner myLock = (LockOwner)this.owners.get(ownerId);
        if (compatibility == 1) {
            if (myLock != null && targetLockLevel <= myLock.lockLevel) {
                return true;
            }
            highestOwner = this.getMaxLevelOwner(myLock);
        } else if (compatibility == 2) {
            highestOwner = this.getMaxLevelOwner(targetLockLevel);
        } else if (compatibility == 3) {
            if (myLock != null && targetLockLevel <= myLock.lockLevel) {
                return true;
            }
            highestOwner = this.getMaxLevelOwner(myLock, targetLockLevel);
        } else {
            highestOwner = this.getMaxLevelOwner();
        }
        int currentLockLevel = highestOwner != null ? highestOwner.lockLevel : this.getLevelMinLock();
        if (targetLockLevel <= this.getLevelMaxLock() - currentLockLevel) {
            this.setLockLevel(ownerId, myLock, targetLockLevel);
            return true;
        }
        return false;
    }

    private static class LockOwner {
        public Object ownerId;
        public int lockLevel;

        public LockOwner(Object ownerId, int lockLevel) {
            this.ownerId = ownerId;
            this.lockLevel = lockLevel;
        }
    }
}

