/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.transaction.memory;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.transaction.locking.GenericLock;
import org.apache.commons.transaction.locking.GenericLockManager;
import org.apache.commons.transaction.locking.LockManager;
import org.apache.commons.transaction.locking.MultiLevelLock;
import org.apache.commons.transaction.memory.HashMapFactory;
import org.apache.commons.transaction.memory.HashSetFactory;
import org.apache.commons.transaction.memory.LockException;
import org.apache.commons.transaction.memory.MapFactory;
import org.apache.commons.transaction.memory.SetFactory;
import org.apache.commons.transaction.memory.TransactionalMapWrapper;
import org.apache.commons.transaction.util.LoggerFacade;

public class PessimisticMapWrapper
extends TransactionalMapWrapper {
    protected static final int READ = 1;
    protected static final int WRITE = 2;
    protected static final String GLOBAL_LOCK_NAME = "GLOBAL";
    protected LockManager lockManager;
    protected MultiLevelLock globalLock;
    protected long readTimeOut = 60000L;

    public PessimisticMapWrapper(Map wrapped, LoggerFacade logger) {
        this(wrapped, new HashMapFactory(), new HashSetFactory(), logger);
    }

    public PessimisticMapWrapper(Map wrapped, MapFactory mapFactory, SetFactory setFactory, LoggerFacade logger) {
        super(wrapped, mapFactory, setFactory);
        this.lockManager = new GenericLockManager(2, logger);
        this.globalLock = new GenericLock(GLOBAL_LOCK_NAME, 2, logger);
    }

    public void startTransaction() {
        if (this.getActiveTx() != null) {
            throw new IllegalStateException("Active thread " + Thread.currentThread() + " already associated with a transaction!");
        }
        LockingTxContext context = new LockingTxContext();
        this.setActiveTx(context);
    }

    public Collection values() {
        this.assureGlobalLock(1);
        return super.values();
    }

    public Set entrySet() {
        this.assureGlobalLock(1);
        return super.entrySet();
    }

    public Set keySet() {
        this.assureGlobalLock(1);
        return super.keySet();
    }

    public Object remove(Object key) {
        this.assureWriteLock(key);
        return super.remove(key);
    }

    public Object put(Object key, Object value) {
        this.assureWriteLock(key);
        return super.put(key, value);
    }

    protected void assureWriteLock(Object key) {
        LockingTxContext txContext = (LockingTxContext)this.getActiveTx();
        if (txContext != null) {
            txContext.lock(this.lockManager.atomicGetOrCreateLock(key), 2);
            txContext.lock(this.globalLock, 1);
        }
    }

    protected void assureGlobalLock(int level) {
        LockingTxContext txContext = (LockingTxContext)this.getActiveTx();
        if (txContext != null) {
            txContext.lock(this.globalLock, level);
        }
    }

    public class LockingTxContext
    extends TransactionalMapWrapper.TxContext {
        protected Set locks = new HashSet();

        protected LockingTxContext() {
            super(PessimisticMapWrapper.this);
        }

        protected Set keys() {
            this.lock(PessimisticMapWrapper.this.globalLock, 1);
            return super.keys();
        }

        protected Object get(Object key) {
            this.lock(PessimisticMapWrapper.this.lockManager.atomicGetOrCreateLock(key), 1);
            this.lock(PessimisticMapWrapper.this.globalLock, 1);
            return super.get(key);
        }

        protected void put(Object key, Object value) {
            this.lock(PessimisticMapWrapper.this.lockManager.atomicGetOrCreateLock(key), 2);
            this.lock(PessimisticMapWrapper.this.globalLock, 1);
            super.put(key, value);
        }

        protected void remove(Object key) {
            this.lock(PessimisticMapWrapper.this.lockManager.atomicGetOrCreateLock(key), 2);
            this.lock(PessimisticMapWrapper.this.globalLock, 1);
            super.remove(key);
        }

        protected int size() {
            this.lock(PessimisticMapWrapper.this.globalLock, 1);
            return super.size();
        }

        protected void clear() {
            this.lock(PessimisticMapWrapper.this.globalLock, 2);
            super.clear();
        }

        protected void dispose() {
            super.dispose();
            Iterator it = this.locks.iterator();
            while (it.hasNext()) {
                MultiLevelLock lock = (MultiLevelLock)it.next();
                lock.release(this);
            }
        }

        protected void finalize() throws Throwable {
            this.dispose();
            super.finalize();
        }

        protected void lock(MultiLevelLock lock, int level) throws LockException {
            boolean acquired = false;
            try {
                acquired = lock.acquire(this, level, true, true, PessimisticMapWrapper.this.readTimeOut);
            }
            catch (InterruptedException e) {
                throw new LockException("Interrupted", 1, PessimisticMapWrapper.GLOBAL_LOCK_NAME);
            }
            if (!acquired) {
                throw new LockException("Timed out", 2, PessimisticMapWrapper.GLOBAL_LOCK_NAME);
            }
            this.locks.add(lock);
        }
    }
}

