/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import net.sourceforge.ganttproject.GanttOptions;
import net.sourceforge.ganttproject.gui.TestGanttRolloverButton;
import net.sourceforge.ganttproject.language.GanttLanguage;

public class GPToolBar
extends JToolBar {
    public static final Object SEPARATOR_OBJECT = new Object(){
        private final String myString = GanttLanguage.getInstance().getText("separator");

        public String toString() {
            return this.myString;
        }
    };
    private final GanttOptions options;
    private List myButtons;

    public GPToolBar(String title, int toolBarPosition, GanttOptions options) {
        super(title, toolBarPosition);
        this.setBorderPainted(true);
        this.setRollover(true);
        this.setFloatable(true);
        this.options = options;
    }

    void populate(List buttons) {
        this.removeAll();
        this.myButtons = new ArrayList(buttons.size());
        for (int i = 0; i < buttons.size(); ++i) {
            Object nextButton = buttons.get(i);
            if (SEPARATOR_OBJECT.equals(nextButton)) {
                int size = Integer.parseInt(this.options.getIconSize());
                ImageIcon icon = this.getOrientation() == 0 ? new ImageIcon(this.getClass().getResource("/icons/sepV_16.png")) : new ImageIcon(this.getClass().getResource("/icons/sepH_16.png"));
                this.add(new JLabel(icon));
                continue;
            }
            this.add((AbstractButton)nextButton);
            if (!(nextButton instanceof TestGanttRolloverButton)) continue;
            this.myButtons.add(nextButton);
        }
        this.invalidate();
    }

    void updateButtonsLook() {
        for (int i = 0; i < this.myButtons.size(); ++i) {
            TestGanttRolloverButton nextButton = (TestGanttRolloverButton)this.myButtons.get(i);
            nextButton.setIconHidden(this.options.getButtonShow() == 2);
            nextButton.setTextHidden(this.options.getButtonShow() == 0);
        }
        this.invalidate();
    }
}

