/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.Box;
import javax.swing.JPanel;
import net.sourceforge.ganttproject.chart.Chart;
import net.sourceforge.ganttproject.gui.ResourceTreeUIFacade;
import net.sourceforge.ganttproject.gui.TestGanttRolloverButton;
import org.eclipse.core.runtime.IAdaptable;

class ResourceChartTabContentPanel
implements IAdaptable {
    private ResourceTreeUIFacade myTreeFacade;
    private Component myResourceChart;
    private JPanel myTabContentPanel;

    ResourceChartTabContentPanel(ResourceTreeUIFacade resourceTree, Component resourceChart) {
        this.myTreeFacade = resourceTree;
        this.myResourceChart = resourceChart;
    }

    Component getComponent() {
        if (this.myTabContentPanel == null) {
            this.myTabContentPanel = new JPanel(new BorderLayout());
            Component buttonPanel = this.createButtonPanel();
            this.myTabContentPanel.add(buttonPanel, "North");
            this.myTabContentPanel.add(this.myTreeFacade.getUIComponent(), "Center");
        }
        return this.myTabContentPanel;
    }

    private Component createButtonPanel() {
        Box buttonBar = Box.createHorizontalBox();
        TestGanttRolloverButton upButton = new TestGanttRolloverButton(this.myTreeFacade.getMoveUpAction());
        upButton.setTextHidden(true);
        buttonBar.add(upButton);
        TestGanttRolloverButton downButton = new TestGanttRolloverButton(this.myTreeFacade.getMoveDownAction());
        downButton.setTextHidden(true);
        buttonBar.add(downButton);
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)buttonBar, "West");
        return buttonPanel;
    }

    public Object getAdapter(Class adapter) {
        if (Container.class.equals(adapter)) {
            return this.getComponent();
        }
        if (Chart.class.equals(adapter)) {
            return this.myResourceChart;
        }
        return null;
    }
}

