/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.ganttproject.font.Fonts;
import net.sourceforge.ganttproject.resource.HumanResource;
import net.sourceforge.ganttproject.resource.HumanResourceManager;
import net.sourceforge.ganttproject.task.ResourceAssignment;
import net.sourceforge.ganttproject.util.TextLengthCalculatorImpl;

class ResourceTreeImageGenerator {
    private HumanResourceManager myResourceManager;
    private final Color BORDER_COLOR_3D = new Color(0.807f, 0.807f, 0.807f);
    private final Color ODD_ROW_COLOR = new Color(0.933f, 0.933f, 0.933f);
    private final int myRowHeight;

    ResourceTreeImageGenerator(HumanResourceManager resourceManager) {
        this.myResourceManager = resourceManager;
        BufferedImage testImage = new BufferedImage(10, 10, 1);
        Graphics g = testImage.getGraphics();
        int nameFontHeight = g.getFontMetrics().getHeight();
        int nameLinePadding = 3;
        this.myRowHeight = nameFontHeight + 6;
    }

    BufferedImage createImage() {
        Dimension d = this.calculateDimension();
        BufferedImage image = new BufferedImage(d.width, d.height, 1);
        Graphics g = image.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, d.width, d.height);
        this.printResources(g, d.width);
        return image;
    }

    private int getRowHeight() {
        return this.myRowHeight;
    }

    private Dimension calculateDimension() {
        int width = 0;
        int assignmentsCount = 0;
        BufferedImage testImage = new BufferedImage(10, 10, 1);
        Graphics g = testImage.getGraphics();
        int tabSize = 5;
        List users = this.myResourceManager.getResources();
        Iterator user = users.iterator();
        while (user.hasNext()) {
            ResourceAssignment[] assignments;
            HumanResource hr = (HumanResource)user.next();
            int nameWidth = TextLengthCalculatorImpl.getTextLength(g, hr.getName());
            if (nameWidth > width) {
                width = nameWidth;
            }
            if ((assignments = hr.getAssignments()) == null) continue;
            for (int i = 0; i < assignments.length; ++i) {
                if (!this.isAssignmentVisible(assignments[i])) continue;
                int taskWidth = 5 + TextLengthCalculatorImpl.getTextLength(g, assignments[i].getTask().getName());
                if (taskWidth > width) {
                    width = taskWidth;
                }
                ++assignmentsCount;
            }
        }
        int height = (assignmentsCount + users.size()) * this.getRowHeight() + 90;
        return new Dimension(width += 20, height);
    }

    private void printResources(Graphics g, int width) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setColor(Color.black);
        g.setFont(Fonts.RESSOURCE_FONT);
        List users = this.myResourceManager.getResources();
        int y = 67;
        int nameLinePadding = 3;
        int nameLineHeight = this.getRowHeight();
        boolean isOddRow = false;
        Iterator user = users.iterator();
        while (user.hasNext()) {
            HumanResource hr = (HumanResource)user.next();
            String nameOfRes = hr.toString();
            if (isOddRow) {
                g.setColor(this.ODD_ROW_COLOR);
                g.fillRect(0, y, width, nameLineHeight);
            }
            g.setColor(Color.black);
            g.drawRect(0, y, width, nameLineHeight);
            g.drawString(nameOfRes, 5, y + nameLineHeight - 3);
            g.setColor(this.BORDER_COLOR_3D);
            g.drawLine(1, y + nameLineHeight - 1, width - 1, y + nameLineHeight - 1);
            y += nameLineHeight;
            boolean bl = isOddRow = !isOddRow;
            ResourceAssignment[] assignments = hr.getAssignments();
            if (assignments == null) continue;
            for (int i = 0; i < assignments.length; ++i) {
                if (!this.isAssignmentVisible(assignments[i])) continue;
                if (isOddRow) {
                    g.setColor(this.ODD_ROW_COLOR);
                    g.fillRect(0, y, width, nameLineHeight);
                }
                g.setColor(Color.black);
                g.drawRect(0, y, width, nameLineHeight);
                g.drawString("  " + assignments[i].getTask().getName(), 5, y + nameLineHeight - 3);
                g.setColor(this.BORDER_COLOR_3D);
                g.drawLine(1, y + nameLineHeight, width - 1, y + nameLineHeight - 1);
                y += nameLineHeight;
                isOddRow = !isOddRow;
            }
        }
    }

    protected boolean isAssignmentVisible(ResourceAssignment assignment) {
        return true;
    }
}

