/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.ganttproject.GanttTree2;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskContainmentHierarchyFacade;
import net.sourceforge.ganttproject.task.TaskManager;
import net.sourceforge.ganttproject.task.TaskNode;
import net.sourceforge.ganttproject.task.dependency.TaskDependencyException;

class TaskContainmentHierarchyFacadeImpl
implements TaskContainmentHierarchyFacade {
    private Map myTask2treeNode = new HashMap();
    private Task myRootTask;
    private List myPathBuffer = new ArrayList();
    private GanttTree2 myTree;

    public TaskContainmentHierarchyFacadeImpl(GanttTree2 tree) {
        ArrayList allTasks = tree.getAllTasks();
        Iterator it = allTasks.iterator();
        while (it.hasNext()) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)it.next();
            Task task = (Task)treeNode.getUserObject();
            if (treeNode.isRoot()) {
                this.myRootTask = task;
            }
            this.myTask2treeNode.put(task, treeNode);
        }
        this.myTree = tree;
    }

    public Task[] getNestedTasks(Task container) {
        Task[] result = null;
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)this.myTask2treeNode.get(container);
        if (treeNode != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            Enumeration<TreeNode> children = treeNode.children();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode next = (DefaultMutableTreeNode)children.nextElement();
                if (!(next instanceof TaskNode)) continue;
                list.add(next.getUserObject());
            }
            result = list.toArray(new Task[0]);
        }
        return result == null ? new Task[]{} : result;
    }

    public boolean hasNestedTasks(Task container) {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)this.myTask2treeNode.get(container);
        return treeNode != null && treeNode.children().hasMoreElements();
    }

    public Task getRootTask() {
        return this.myRootTask;
    }

    public Task getContainer(Task nestedTask) {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)this.myTask2treeNode.get(nestedTask);
        if (treeNode == null) {
            return null;
        }
        DefaultMutableTreeNode containerNode = (DefaultMutableTreeNode)treeNode.getParent();
        return containerNode == null ? null : (Task)containerNode.getUserObject();
    }

    public boolean areUnrelated(Task first, Task second) {
        this.myPathBuffer.clear();
        Task container = this.getContainer(first);
        while (container != null) {
            this.myPathBuffer.add(container);
            container = this.getContainer(container);
        }
        if (this.myPathBuffer.contains(second)) {
            return false;
        }
        this.myPathBuffer.clear();
        container = this.getContainer(second);
        while (container != null) {
            this.myPathBuffer.add(container);
            container = this.getContainer(container);
        }
        return !this.myPathBuffer.contains(first);
    }

    public void move(Task whatMove, Task whereMove) {
        DefaultMutableTreeNode targetNode = (DefaultMutableTreeNode)this.myTask2treeNode.get(whereMove);
        DefaultMutableTreeNode movedNode = (DefaultMutableTreeNode)this.myTask2treeNode.get(whatMove);
        if (movedNode != null) {
            TreePath movedPath = new TreePath(movedNode.getPath());
            boolean wasSelected = this.myTree.getJTree().getSelectionModel().isPathSelected(movedPath);
            if (wasSelected) {
                this.myTree.getJTree().getSelectionModel().removeSelectionPath(movedPath);
            }
            this.myTree.getModel().removeNodeFromParent(movedNode);
            this.myTree.getModel().insertNodeInto(movedNode, targetNode, targetNode.getChildCount());
            if (wasSelected) {
                movedPath = new TreePath(movedNode.getPath());
                this.myTree.getJTree().getSelectionModel().addSelectionPath(movedPath);
            }
        } else {
            this.myTree.addObjectWithExpand(whatMove, targetNode);
        }
        this.getTaskManager().getAlgorithmCollection().getAdjustTaskBoundsAlgorithm().run(whatMove);
        try {
            this.getTaskManager().getAlgorithmCollection().getRecalculateTaskScheduleAlgorithm().run();
        }
        catch (TaskDependencyException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private TaskManager getTaskManager() {
        return this.myRootTask.getManager();
    }

    public int getDepth(Task task) {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)this.myTask2treeNode.get(task);
        return treeNode.getLevel();
    }

    public int compareDocumentOrder(Task task1, Task task2) {
        DefaultMutableTreeNode node1 = (DefaultMutableTreeNode)this.myTask2treeNode.get(task1);
        DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)this.myTask2treeNode.get(task2);
        int row1 = this.myTree.getJTree().getRowForPath(new TreePath(node1.getPath()));
        int row2 = this.myTree.getJTree().getRowForPath(new TreePath(node2.getPath()));
        return row1 - row2;
    }

    public boolean contains(Task task) {
        return this.myTask2treeNode.containsKey(task);
    }
}

