/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.action;

import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import net.sourceforge.ganttproject.action.RolloverAction;
import net.sourceforge.ganttproject.language.GanttLanguage;
import org.eclipse.core.runtime.Platform;

public abstract class GPAction
extends AbstractAction
implements RolloverAction,
GanttLanguage.Listener {
    public static final int MENU_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    protected boolean iconVisible = true;
    private Icon myIcon = null;
    private static Properties ourProperties;

    protected GPAction() {
        this(null, "16");
    }

    protected GPAction(String name, String iconSize) {
        super(name);
        this.setIconSize(iconSize);
        this.updateName();
        this.updateTooltip();
        GanttLanguage.getInstance().addListener(this);
    }

    public GPAction(String name) {
        this(name, "16");
    }

    public Icon getIconOnMouseOver() {
        return (Icon)this.getValue("SmallIcon");
    }

    public void setIconSize(String iconSize) {
        Icon icon = this.createIcon(iconSize);
        if (icon != null) {
            this.putValue("SmallIcon", icon);
            this.myIcon = icon;
        }
    }

    protected Icon createIcon(String iconSize) {
        if (iconSize == null || !this.iconVisible) {
            return null;
        }
        URL resource = this.getClass().getResource(this.getIconFileDirectory() + "/" + this.getIconFilePrefix() + iconSize + ".gif");
        return resource == null ? null : new ImageIcon(resource);
    }

    protected String getIconFileDirectory() {
        return "/icons";
    }

    protected String getLocalizedName() {
        return "";
    }

    protected String getTooltipText() {
        String localizedName = this.getLocalizedName();
        return localizedName == null ? "" : GanttLanguage.getInstance().correctLabel(this.getLocalizedName());
    }

    protected String getI18n(String key) {
        return GanttLanguage.getInstance().getText(key);
    }

    protected abstract String getIconFilePrefix();

    public void setIconVisible(boolean isVisible) {
        this.iconVisible = isVisible;
        this.putValue("SmallIcon", this.iconVisible ? this.myIcon : null);
    }

    private void updateName() {
        String localizedName = this.getLocalizedName();
        if (localizedName == null) {
            localizedName = String.valueOf(this.getValue("Name"));
        }
        if (localizedName != null) {
            int bucksPos = localizedName.indexOf(36);
            if (bucksPos >= 0) {
                localizedName = new StringBuffer(localizedName).deleteCharAt(bucksPos).toString();
            }
            this.putValue("Name", localizedName);
            if (bucksPos >= 0) {
                this.putValue("MnemonicKey", new Integer(Character.toLowerCase(localizedName.charAt(bucksPos))));
            }
        }
    }

    private void updateTooltip() {
        this.putValue("ShortDescription", "<html><body bgcolor=#EAEAEA>" + this.getTooltipText() + "</body></html>");
    }

    public void isIconVisible(boolean isNull) {
        this.setIconVisible(isNull);
    }

    public void languageChanged(GanttLanguage.Event event) {
        this.updateName();
        this.updateTooltip();
    }

    public static KeyStroke getKeyStroke(String keystrokeID) {
        if (ourProperties == null) {
            ourProperties = new Properties();
            URL url = GPAction.class.getResource("/keyboard.properties");
            if (url == null) {
                return null;
            }
            try {
                URL resolvedUrl = Platform.resolve((URL)url);
                ourProperties.load(resolvedUrl.openStream());
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        String stringKeyStroke = (String)ourProperties.get(keystrokeID);
        return KeyStroke.getKeyStroke(stringKeyStroke);
    }
}

