/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.action;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import net.sourceforge.ganttproject.GanttProject;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.Mediator;
import net.sourceforge.ganttproject.language.GanttLanguage;

public class NewTaskAction
extends AbstractAction
implements GanttLanguage.Listener {
    private final IGanttProject myProject;

    public NewTaskAction(IGanttProject project) {
        this.myProject = project;
        this.setText(project.getI18n());
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        URL iconUrl = this.getClass().getClassLoader().getResource("icons/insert_16.gif");
        if (iconUrl != null) {
            this.putValue("SmallIcon", new ImageIcon(iconUrl));
        }
        project.getI18n().addListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        Mediator.getUndoManager().undoableEdit("New Task", new Runnable(){

            public void run() {
                NewTaskAction.this.myProject.newTask();
            }
        });
    }

    public void languageChanged(GanttLanguage.Event event) {
        this.setText(event.getLanguage());
    }

    private void setText(GanttLanguage language) {
        this.putValue("Name", GanttProject.correctLabel(language.getText("newTask")));
    }
}

