/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.chart;

import net.sourceforge.ganttproject.chart.ChartModelBase;
import net.sourceforge.ganttproject.chart.ChartRendererBase;
import net.sourceforge.ganttproject.chart.ChartUIConfiguration;
import net.sourceforge.ganttproject.chart.GraphicPrimitiveContainer;
import net.sourceforge.ganttproject.chart.TimeUnitVisitor;
import net.sourceforge.ganttproject.time.TimeFrame;
import net.sourceforge.ganttproject.time.TimeUnit;
import net.sourceforge.ganttproject.time.TimeUnitText;

public class BottomUnitLineRendererImpl
extends ChartRendererBase
implements TimeUnitVisitor {
    private TimeFrame myCurrentTimeFrame;
    private boolean areUnitsAccepted;
    private BottomUnitGridBuilder myBottomUnitGridBuilder;
    private int posX;

    public BottomUnitLineRendererImpl(ChartModelBase model) {
        super(model);
        this.myBottomUnitGridBuilder = new BottomUnitGridBuilder(model);
    }

    public void beforeProcessingTimeFrames() {
        this.getPrimitiveContainer().clear();
        this.posX = 0;
    }

    public void afterProcessingTimeFrames() {
    }

    public void startTimeFrame(TimeFrame timeFrame) {
        this.myCurrentTimeFrame = timeFrame;
    }

    public void endTimeFrame(TimeFrame timeFrame) {
        this.posX += this.myBottomUnitGridBuilder.getWidth();
        this.myCurrentTimeFrame = null;
    }

    public void startUnitLine(TimeUnit timeUnit) {
        if (timeUnit == this.myCurrentTimeFrame.getBottomUnit()) {
            this.myBottomUnitGridBuilder.beforeProcessingGrid(this.posX);
            this.areUnitsAccepted = true;
        }
    }

    public void endUnitLine(TimeUnit timeUnit) {
        if (this.areUnitsAccepted) {
            this.myBottomUnitGridBuilder.afterProcessingGrid();
        }
        this.areUnitsAccepted = false;
    }

    public void nextTimeUnit(int unitIndex) {
        if (this.areUnitsAccepted) {
            this.myBottomUnitGridBuilder.visitUnit(this.myCurrentTimeFrame, unitIndex);
        }
    }

    class BottomUnitGridBuilder {
        final int totalWidth = this.getWidth();
        final ChartUIConfiguration config;
        int myWidth = 0;
        int myPosX;
        private int myPosFrameStart;

        public BottomUnitGridBuilder(ChartModelBase chartModel) {
            this.config = chartModel.getChartUIConfiguration();
        }

        void beforeProcessingGrid(int posFrameStart) {
            this.myWidth = 0;
            this.myPosX = posFrameStart;
            this.myPosFrameStart = posFrameStart;
        }

        void visitUnit(TimeFrame currentFrame, int unitIndex) {
            int topUnitHeight = this.config.getSpanningHeaderHeight();
            int bottomY = topUnitHeight * 2 - 2;
            GraphicPrimitiveContainer.Line nextLine = BottomUnitLineRendererImpl.this.getPrimitiveContainer().createLine(this.myPosX, topUnitHeight, this.myPosX, bottomY);
            nextLine.setForegroundColor(this.config.getBottomUnitGridColor());
            TimeUnitText timeUnitText = currentFrame.getUnitText(currentFrame.getBottomUnit(), unitIndex);
            String unitText = currentFrame.getUnitText(currentFrame.getBottomUnit(), unitIndex).getText(-1);
            GraphicPrimitiveContainer.Text nextText = BottomUnitLineRendererImpl.this.getPrimitiveContainer().createText(this.myPosX + 2, bottomY - 7, unitText);
            nextText.setMaxLength(BottomUnitLineRendererImpl.this.getChartModel().getBottomUnitWidth(currentFrame));
            nextText.setFont(this.config.getBottomUnitFont());
            this.myPosX += BottomUnitLineRendererImpl.this.getChartModel().getBottomUnitWidth(currentFrame);
            BottomUnitLineRendererImpl.this.getPrimitiveContainer().bind(nextText, timeUnitText);
        }

        void afterProcessingGrid() {
            this.myWidth = this.myPosX - this.myPosFrameStart;
        }

        int getWidth() {
            return this.myWidth;
        }
    }
}

