/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.chart;

import java.awt.Color;
import java.util.Date;
import java.util.GregorianCalendar;
import net.sourceforge.ganttproject.calendar.GPCalendar;
import net.sourceforge.ganttproject.chart.ChartModelBase;
import net.sourceforge.ganttproject.chart.ChartOptionGroup;
import net.sourceforge.ganttproject.chart.ChartRendererBase;
import net.sourceforge.ganttproject.chart.DayTypeAlternance;
import net.sourceforge.ganttproject.chart.GraphicPrimitiveContainer;
import net.sourceforge.ganttproject.chart.TimeUnitVisitor;
import net.sourceforge.ganttproject.gui.UIConfiguration;
import net.sourceforge.ganttproject.gui.options.model.BooleanOption;
import net.sourceforge.ganttproject.gui.options.model.DefaultBooleanOption;
import net.sourceforge.ganttproject.gui.options.model.GP1XOptionConverter;
import net.sourceforge.ganttproject.gui.options.model.GPOption;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import net.sourceforge.ganttproject.time.TimeFrame;
import net.sourceforge.ganttproject.time.TimeUnit;
import net.sourceforge.ganttproject.time.gregorian.FramerImpl;

public class ChartGridImpl
extends ChartRendererBase
implements TimeUnitVisitor {
    private int myPosX;
    private TimeFrame myCurrentFrame;
    private boolean areUnitsAccepted;
    private TimeUnit myCurrentUnit;
    private Date myToday;
    private BooleanOption myRedlineOption;
    private BooleanOption myProjectDatesOption = new DefaultBooleanOption("showProjectDates");
    private GPOptionGroup myOptions;
    private Date projectEnd = null;
    private Date projectStart = null;
    private FramerImpl myDayFramer = new FramerImpl(5);

    public ChartGridImpl(ChartModelBase chartModel, UIConfiguration projectConfig) {
        super(chartModel);
        class RedlineOption
        extends DefaultBooleanOption
        implements GP1XOptionConverter {
            private final /* synthetic */ UIConfiguration val$projectConfig;

            RedlineOption(UIConfiguration val$projectConfig) {
                this.val$projectConfig = val$projectConfig;
                super("showTodayLine");
            }

            public String getTagName() {
                return "redline";
            }

            public String getAttributeName() {
                return "value";
            }

            public void loadValue(String legacyValue) {
                this.lock();
                this.loadPersistentValue(legacyValue);
                this.commit();
            }

            public void commit() {
                super.commit();
                this.val$projectConfig.setRedlineOn(this.isChecked());
            }
        }
        this.myRedlineOption = new RedlineOption(projectConfig);
        this.myOptions = new ChartOptionGroup("ganttChartGridDetails", new GPOption[]{this.myRedlineOption, this.myProjectDatesOption}, chartModel.getOptionEventDispatcher());
    }

    GPOptionGroup getOptions() {
        return this.myOptions;
    }

    public void beforeProcessingTimeFrames() {
        this.getPrimitiveContainer().clear();
        this.myPosX = 0;
        this.myToday = this.myDayFramer.adjustLeft(GregorianCalendar.getInstance().getTime());
        this.projectStart = this.getChartModel().getTaskManager().getProjectStart();
        this.projectEnd = this.getChartModel().getTaskManager().getProjectEnd();
    }

    public void startTimeFrame(TimeFrame timeFrame) {
        this.myCurrentFrame = timeFrame;
    }

    public void endTimeFrame(TimeFrame timeFrame) {
        this.myCurrentFrame = null;
    }

    public void startUnitLine(TimeUnit timeUnit) {
        if (timeUnit == this.myCurrentFrame.getBottomUnit()) {
            this.areUnitsAccepted = true;
            this.myCurrentUnit = timeUnit;
        }
    }

    public void endUnitLine(TimeUnit timeUnit) {
        this.areUnitsAccepted = false;
        this.myCurrentUnit = null;
    }

    public void nextTimeUnit(int unitIndex) {
        if (this.areUnitsAccepted) {
            Date unitStart = this.myCurrentFrame.getUnitStart(this.myCurrentUnit, unitIndex);
            DayTypeAlternance[] alternance = this.getChartModel().getDayTypeAlternance(this.myCurrentFrame, this.myCurrentUnit, unitIndex);
            ChartModelBase.Offset[] offsets = this.getChartModel().calculateOffsets(this.myCurrentFrame, this.myCurrentUnit, unitStart, this.getChartModel().getTimeUnitStack().getDefaultTimeUnit(), this.getChartModel().getBottomUnitWidth());
            if (this.myRedlineOption.isChecked()) {
                this.drawDateLine(unitStart, unitIndex, this.myToday, offsets, Color.RED, 2);
            }
            if (this.isProjectBoundariesOptionOn()) {
                this.drawDateLine(unitStart, unitIndex, this.projectStart, offsets, Color.BLUE, 0);
                this.drawDateLine(unitStart, unitIndex, this.projectEnd, offsets, Color.BLUE, 0);
            }
            int prevOffset = 0;
            for (int i = 0; i < alternance.length; ++i) {
                DayTypeAlternance next = alternance[i];
                int alternanceEndOffset = this.getChartModel().getBottomUnitWidth();
                for (int j = 0; j < offsets.length; ++j) {
                    if (!offsets[j].getOffsetEnd().equals(next.getEnd())) continue;
                    alternanceEndOffset = offsets[j].getOffsetPixels();
                    break;
                }
                if (GPCalendar.DayType.WEEKEND == next.getDayType()) {
                    GraphicPrimitiveContainer.Rectangle r = this.getPrimitiveContainer().createRectangle(this.myPosX + prevOffset, 0, alternanceEndOffset - prevOffset, this.getHeight());
                    r.setBackgroundColor(this.getConfig().getHolidayTimeBackgroundColor());
                    r.setStyle("calendar.holiday");
                    this.getPrimitiveContainer().bind(r, next.getDayType());
                }
                if (GPCalendar.DayType.HOLIDAY == next.getDayType()) {
                    GraphicPrimitiveContainer.Rectangle r = this.getPrimitiveContainer().createRectangle(this.myPosX + prevOffset, 0, alternanceEndOffset, this.getHeight());
                    r.setBackgroundColor(this.getConfig().getPublicHolidayTimeBackgroundColor());
                    r.setStyle("calendar.holiday");
                    this.getPrimitiveContainer().bind(r, next.getDayType());
                }
                prevOffset = alternanceEndOffset;
            }
            this.myPosX += this.getChartModel().getBottomUnitWidth();
        }
    }

    public void afterProcessingTimeFrames() {
    }

    private void drawDateLine(Date unitStart, int unitIndex, Date lineDate, ChartModelBase.Offset[] offsets, Color color, int horizontalOffset) {
        int redLineOffset = -1;
        if (unitStart.before(lineDate) && this.myCurrentFrame.getUnitFinish(this.myCurrentUnit, unitIndex).after(lineDate)) {
            for (int i = 0; i < offsets.length; ++i) {
                if (!offsets[i].getOffsetEnd().equals(lineDate)) continue;
                redLineOffset = offsets[i].getOffsetPixels();
                break;
            }
        } else if (unitStart.equals(lineDate)) {
            redLineOffset = 0;
        }
        if (redLineOffset >= 0) {
            GraphicPrimitiveContainer.Line redLine = this.getPrimitiveContainer().createLine(this.myPosX + redLineOffset + horizontalOffset, 0, this.myPosX + redLineOffset + horizontalOffset, this.getHeight());
            redLine.setForegroundColor(color);
        }
    }

    private boolean isProjectBoundariesOptionOn() {
        return this.myProjectDatesOption.isChecked();
    }
}

