/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.chart;

import java.util.List;
import net.sourceforge.ganttproject.chart.ChartModelImpl;
import net.sourceforge.ganttproject.chart.ChartRendererBase;
import net.sourceforge.ganttproject.chart.GraphicPrimitiveContainer;
import net.sourceforge.ganttproject.chart.TimeUnitVisitor;
import net.sourceforge.ganttproject.task.ResourceAssignment;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.time.TimeFrame;
import net.sourceforge.ganttproject.time.TimeUnit;

public class ResourcesRendererImpl
extends ChartRendererBase
implements TimeUnitVisitor {
    public ResourcesRendererImpl(ChartModelImpl model) {
        super(model);
    }

    public void beforeProcessingTimeFrames() {
    }

    public void afterProcessingTimeFrames() {
        List visibleTasks = ((ChartModelImpl)this.getChartModel()).getVisibleTasks();
        int bottomY = this.getConfig().getRowHeight();
        for (int i = 0; i < visibleTasks.size(); ++i) {
            Task nextTask = (Task)visibleTasks.get(i);
            ResourceAssignment[] assignments = nextTask.getAssignments();
            if (assignments.length > 0) {
                StringBuffer resources = new StringBuffer();
                for (int j = 0; j < assignments.length; ++j) {
                    resources.append(assignments[j].getResource().getName());
                    if (j >= assignments.length - 1) continue;
                    resources.append(", ");
                }
                GraphicPrimitiveContainer.Text text = this.getPrimitiveContainer().createText(0, bottomY, resources.toString());
                text.setStyle("task.resources");
            }
            bottomY += this.getConfig().getRowHeight();
        }
    }

    public void startTimeFrame(TimeFrame timeFrame) {
    }

    public void endTimeFrame(TimeFrame timeFrame) {
    }

    public void startUnitLine(TimeUnit timeUnit) {
    }

    public void endUnitLine(TimeUnit timeUnit) {
    }

    public void nextTimeUnit(int unitIndex) {
    }
}

