/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.delay;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.UndoableEditEvent;
import net.sourceforge.ganttproject.GanttTree2;
import net.sourceforge.ganttproject.Mediator;
import net.sourceforge.ganttproject.delay.Delay;
import net.sourceforge.ganttproject.delay.DelayObserver;
import net.sourceforge.ganttproject.task.Task;
import net.sourceforge.ganttproject.task.TaskManager;
import net.sourceforge.ganttproject.task.TaskNode;
import net.sourceforge.ganttproject.task.event.TaskDependencyEvent;
import net.sourceforge.ganttproject.task.event.TaskHierarchyEvent;
import net.sourceforge.ganttproject.task.event.TaskListener;
import net.sourceforge.ganttproject.task.event.TaskPropertyEvent;
import net.sourceforge.ganttproject.task.event.TaskScheduleEvent;
import net.sourceforge.ganttproject.undo.GPUndoListener;

public class DelayManager
implements TaskListener,
GPUndoListener {
    private static boolean ourCriticProcess = false;
    private Date myToday;
    private List myObservers = new ArrayList();
    private TaskManager myTaskManager;
    private TaskNode myRoot;
    private GanttTree2 myTree;

    public DelayManager(TaskManager taskManager, GanttTree2 tree) {
        this.myTaskManager = taskManager;
        this.myRoot = (TaskNode)tree.getRoot();
        this.myTree = tree;
        Mediator.getUndoManager().addUndoableEditListener(this);
    }

    public void addObserver(DelayObserver observer) {
        this.myObservers.add(observer);
    }

    public void removeObserver(DelayObserver observer) {
        this.myObservers.remove(observer);
    }

    public void fireDelayObservation() {
        this.myToday = new Date();
        if (ourCriticProcess) {
            this.myTaskManager.processCriticalPath(this.myRoot);
            ArrayList projectTasks = this.myTree.getProjectTasks();
            if (projectTasks.size() != 0) {
                for (int i = 0; i < projectTasks.size(); ++i) {
                    this.myTaskManager.processCriticalPath((TaskNode)projectTasks.get(i));
                }
            }
            ourCriticProcess = false;
        }
        Iterator<Task> itTasks = Arrays.asList(this.myTaskManager.getTasks()).iterator();
        while (itTasks.hasNext()) {
            Task task = itTasks.next();
            Delay delay = this.calculateDelay(task);
            Iterator itObservers = this.myObservers.iterator();
            while (itObservers.hasNext()) {
                DelayObserver observer = (DelayObserver)itObservers.next();
                observer.setDelay(task, delay);
            }
        }
    }

    private Delay calculateDelay(Task t) {
        Delay res = Delay.getDelay(-1);
        int completionPercentage = t.getCompletionPercentage();
        if (t.isMilestone() || completionPercentage == 100) {
            return res;
        }
        Date endDate = t.getEnd().getTime();
        if (endDate.before(this.myToday)) {
            if (t.isCritical()) {
                res.setType(1);
            } else {
                res.setType(0);
            }
        }
        return res;
    }

    public void taskScheduleChanged(TaskScheduleEvent e) {
        if (!e.getNewFinishDate().equals(e.getOldFinishDate())) {
            this.fireDelayObservation();
        }
    }

    public void dependencyAdded(TaskDependencyEvent e) {
        this.fireDelayObservation();
    }

    public void dependencyRemoved(TaskDependencyEvent e) {
        this.fireDelayObservation();
    }

    public void taskAdded(TaskHierarchyEvent e) {
        this.fireDelayObservation();
    }

    public void taskRemoved(TaskHierarchyEvent e) {
        this.fireDelayObservation();
    }

    public void taskMoved(TaskHierarchyEvent e) {
    }

    public void taskPropertiesChanged(TaskPropertyEvent e) {
    }

    public void taskProgressChanged(TaskPropertyEvent e) {
        this.fireDelayObservation();
    }

    public void undoOrRedoHappened() {
        ourCriticProcess = true;
        this.fireDelayObservation();
    }

    public void undoableEditHappened(UndoableEditEvent arg0) {
    }
}

