/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.export;

import java.io.File;
import java.io.FileOutputStream;
import net.sourceforge.ganttproject.GanttOptions;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.export.ExportFileWizardImpl;
import net.sourceforge.ganttproject.export.ExportFinalizationJob;
import net.sourceforge.ganttproject.export.Exporter;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import net.sourceforge.ganttproject.io.GanttCSVExport;
import net.sourceforge.ganttproject.language.GanttLanguage;

public class ExporterToCSV
implements Exporter,
ExportFileWizardImpl.LegacyOptionsClient {
    private static String[] FILE_EXTENSIONS = new String[]{"csv"};
    private IGanttProject myProject;
    private GanttOptions myOptions;

    public String getFileTypeDescription() {
        return GanttLanguage.getInstance().getText("impex.csv.description");
    }

    public GPOptionGroup getOptions() {
        return null;
    }

    public GPOptionGroup[] getSecondaryOptions() {
        return null;
    }

    public String getFileNamePattern() {
        return FILE_EXTENSIONS[0];
    }

    public void run(File outputFile, ExportFinalizationJob finalizationJob) throws Exception {
        if (!outputFile.exists()) {
            outputFile.createNewFile();
        }
        GanttCSVExport legacyExporter = new GanttCSVExport(this.myProject, this.myOptions.getCSVOptions());
        legacyExporter.save(new FileOutputStream(outputFile));
        finalizationJob.run(new File[]{outputFile});
    }

    public String proposeFileExtension() {
        return FILE_EXTENSIONS[0];
    }

    public String[] getFileExtensions() {
        return FILE_EXTENSIONS;
    }

    public void setContext(IGanttProject project, UIFacade uiFacade) {
        this.myProject = project;
    }

    public void setOptions(GanttOptions options) {
        this.myOptions = options;
    }
}

