/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.export;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import net.sourceforge.ganttproject.GanttOptions;
import net.sourceforge.ganttproject.gui.UIFacade;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;

class WebPublisher {
    WebPublisher() {
    }

    public void run(final File[] exportFiles, final GanttOptions options, UIFacade uiFacade) {
        IJobManager jobManager = Platform.getJobManager();
        IProgressMonitor monitor = jobManager.createProgressGroup();
        Job startingJob = new Job("starting"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Publishing files on FTP", exportFiles.length);
                try {
                    URL baseUrl = new URL("ftp://" + options.getFTPUser() + ":" + options.getFTPPwd() + "@" + options.getFTPUrl() + "/" + options.getFTPDirectory() + "/");
                    for (int i = 0; i < exportFiles.length; ++i) {
                        Job nextJob = WebPublisher.this.createTransferJob(baseUrl, exportFiles[i]);
                        nextJob.setProgressGroup(monitor, 1);
                        nextJob.schedule();
                        nextJob.join();
                    }
                    Job finishingJob = new Job(this, "finishing"){
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                            super(x0);
                        }

                        protected IStatus run(IProgressMonitor monitor) {
                            monitor.done();
                            return Status.OK_STATUS;
                        }
                    };
                    finishingJob.setProgressGroup(monitor, 0);
                    finishingJob.schedule();
                    finishingJob.join();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        };
        startingJob.setProgressGroup(monitor, 0);
        startingJob.schedule();
    }

    private Job createTransferJob(URL baseUrl, final File file) throws IOException {
        final URL outUrl = new URL(baseUrl, file.getName());
        Job result = new Job("transfer file " + file.getName()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            protected IStatus run(IProgressMonitor monitor) {
                IOException e222;
                IStatus iStatus;
                OutputStream outStream;
                FileInputStream inputStream;
                block15: {
                    byte[] buffer = new byte[(int)file.length()];
                    inputStream = null;
                    outStream = null;
                    inputStream = new FileInputStream(file);
                    inputStream.read(buffer);
                    System.err.println("writing to file=" + outUrl);
                    outStream = outUrl.openConnection().getOutputStream();
                    outStream.write(buffer);
                    outStream.flush();
                    monitor.worked(1);
                    iStatus = Status.OK_STATUS;
                    Object var8_7 = null;
                    if (inputStream == null) break block15;
                    try {
                        inputStream.close();
                    }
                    catch (IOException e222) {
                        e222.printStackTrace();
                    }
                }
                if (outStream != null) {
                    try {
                        outStream.close();
                    }
                    catch (IOException e222) {
                        e222.printStackTrace();
                    }
                }
                return iStatus;
                catch (IOException e3) {
                    IOException e222;
                    IStatus iStatus2;
                    block17: {
                        try {
                            e3.printStackTrace();
                            iStatus2 = Status.CANCEL_STATUS;
                            Object var8_8 = null;
                            if (inputStream == null) break block17;
                        }
                        catch (Throwable throwable) {
                            block19: {
                                IOException e222;
                                Object var8_9 = null;
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (IOException e222) {
                                        e222.printStackTrace();
                                    }
                                }
                                if (outStream == null) break block19;
                                try {
                                    outStream.close();
                                }
                                catch (IOException e222) {
                                    e222.printStackTrace();
                                }
                            }
                            throw throwable;
                        }
                        try {
                            inputStream.close();
                        }
                        catch (IOException e222) {
                            e222.printStackTrace();
                        }
                    }
                    if (outStream != null) {
                        try {
                            outStream.close();
                        }
                        catch (IOException e222) {
                            e222.printStackTrace();
                        }
                    }
                    return iStatus2;
                }
            }
        };
        return result;
    }
}

