/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.gui;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.document.Document;
import net.sourceforge.ganttproject.document.DocumentManager;
import net.sourceforge.ganttproject.filter.GanttXMLFileFilter;
import net.sourceforge.ganttproject.gui.GanttURLChooser;
import net.sourceforge.ganttproject.gui.ProjectUIFacade;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import net.sourceforge.ganttproject.gui.projectwizard.NewProjectWizard;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.undo.GPUndoManager;
import net.sourceforge.ganttproject.util.FileUtil;

public class ProjectUIFacadeImpl
implements ProjectUIFacade {
    private final UIFacade myWorkbenchFacade;
    private final GanttLanguage i18n = GanttLanguage.getInstance();
    private final DocumentManager myDocumentManager;
    private final GPUndoManager myUndoManager;

    public ProjectUIFacadeImpl(UIFacade workbenchFacade, DocumentManager documentManager, GPUndoManager undoManager) {
        this.myWorkbenchFacade = workbenchFacade;
        this.myDocumentManager = documentManager;
        this.myUndoManager = undoManager;
    }

    public void saveProject(IGanttProject project) {
        if (project.getDocument() == null) {
            this.saveProjectAs(project);
            return;
        }
        Document document = project.getDocument();
        if (!document.canWrite()) {
            this.myWorkbenchFacade.showErrorDialog(this.i18n.getText("msg10"));
            this.saveProjectAs(project);
            return;
        }
        if (!document.acquireLock()) {
            this.myWorkbenchFacade.showErrorDialog(this.i18n.getText("msg14"));
            this.saveProjectAs(project);
            return;
        }
        try {
            this.saveProject(project.getDocument());
            this.afterSaveProject(project);
        }
        catch (Throwable e) {
            this.myWorkbenchFacade.showErrorDialog(e);
        }
    }

    private void afterSaveProject(IGanttProject project) {
        File file;
        URI url;
        Document document = project.getDocument();
        this.myDocumentManager.addToRecentDocuments(document);
        String title = this.i18n.getText("appliTitle") + " [" + document.getDescription() + "]";
        this.myWorkbenchFacade.setWorkbenchTitle(title);
        if (document.isLocal() && (url = document.getURI()) != null && (file = new File(url)) != null) {
            this.myDocumentManager.changeWorkingDirectory(file.getParentFile());
        }
        project.setModified(false);
    }

    private void saveProject(Document document) throws IOException {
        this.myWorkbenchFacade.setStatusText(GanttLanguage.getInstance().getText("saving") + " " + document.getPath());
        document.write();
    }

    public void saveProjectAs(IGanttProject project) {
        JFileChooser fc = new JFileChooser(this.myDocumentManager.getWorkingDirectory());
        GanttXMLFileFilter ganttFilter = new GanttXMLFileFilter();
        fc.addChoosableFileFilter(ganttFilter);
        FileFilter[] filefilters = fc.getChoosableFileFilters();
        for (int i = 0; i < filefilters.length; ++i) {
            if (filefilters[i] == ganttFilter) continue;
            fc.removeChoosableFileFilter(filefilters[i]);
        }
        try {
            int userChoice;
            while ((userChoice = fc.showSaveDialog(this.myWorkbenchFacade.getMainFrame())) == 0) {
                UIFacade.Choice overwritingChoice;
                File projectfile = fc.getSelectedFile();
                String extension = FileUtil.getExtension(projectfile).toLowerCase();
                if (!"gan".equals(extension) && !"xml".equals(extension)) {
                    projectfile = FileUtil.replaceExtension(projectfile, "gan");
                }
                if (projectfile.exists() && (overwritingChoice = this.myWorkbenchFacade.showConfirmationDialog(projectfile + "\n" + this.i18n.getText("msg18"), this.i18n.getText("warning"))) != UIFacade.Choice.YES) continue;
                Document document = this.myDocumentManager.getDocument(projectfile.getAbsolutePath());
                this.saveProject(document);
                project.setDocument(document);
                this.afterSaveProject(project);
                break;
            }
        }
        catch (Throwable e) {
            this.myWorkbenchFacade.showErrorDialog(e);
        }
    }

    public void saveProjectRemotely(IGanttProject project) {
        Document document = this.showURLDialog(project);
        if (document != null) {
            project.setDocument(document);
            this.saveProject(project);
        }
    }

    private boolean ensureProjectSaved(IGanttProject project) {
        if (project.isModified()) {
            UIFacade.Choice saveChoice = this.myWorkbenchFacade.showConfirmationDialog(this.i18n.getText("msg1"), this.i18n.getText("warning"));
            if (UIFacade.Choice.CANCEL == saveChoice) {
                return false;
            }
            if (UIFacade.Choice.YES == saveChoice) {
                try {
                    this.saveProject(project);
                }
                catch (Exception e) {
                    System.err.println(e);
                    this.myWorkbenchFacade.showErrorDialog(e);
                    return false;
                }
            }
        }
        return true;
    }

    public void openProject(IGanttProject project) {
        if (!this.ensureProjectSaved(project)) {
            return;
        }
        JFileChooser fc = new JFileChooser(this.myDocumentManager.getWorkingDirectory());
        GanttXMLFileFilter ganttFilter = new GanttXMLFileFilter();
        FileFilter[] filefilters = fc.getChoosableFileFilters();
        for (int i = 0; i < filefilters.length; ++i) {
            fc.removeChoosableFileFilter(filefilters[i]);
        }
        fc.addChoosableFileFilter(ganttFilter);
        int returnVal = fc.showOpenDialog(this.myWorkbenchFacade.getMainFrame());
        if (returnVal == 0) {
            JFileChooser jfc = fc;
            Document document = this.getDocumentManager().getDocument(jfc.getSelectedFile().getAbsolutePath());
            this.openProject(document, project);
        }
    }

    public void openRemoteProject(IGanttProject project) {
        Document document = this.showURLDialog(project);
        if (document != null) {
            this.openProject(document, project);
        }
    }

    public void openProject(final Document document, final IGanttProject project) {
        this.getUndoManager().undoableEdit("OpenFile", new Runnable(){

            public void run() {
                try {
                    ProjectUIFacadeImpl.this.beforeClose();
                    project.close();
                    project.open(document);
                }
                catch (IOException e) {
                    ProjectUIFacadeImpl.this.myWorkbenchFacade.showErrorDialog(e);
                }
            }
        });
    }

    private void beforeClose() {
        this.myWorkbenchFacade.setWorkbenchTitle(this.i18n.getText("appliTitle"));
        this.getUndoManager().die();
    }

    public void createProject(final IGanttProject project) {
        if (!this.ensureProjectSaved(project)) {
            return;
        }
        this.getUndoManager().undoableEdit("Init new Project", new Runnable(){

            public void run() {
                ProjectUIFacadeImpl.this.beforeClose();
                project.close();
                ProjectUIFacadeImpl.this.myWorkbenchFacade.setStatusText(ProjectUIFacadeImpl.this.i18n.getText("newProject2"));
                ProjectUIFacadeImpl.this.showNewProjectWizard(project);
            }
        });
    }

    private void showNewProjectWizard(IGanttProject project) {
        NewProjectWizard wizard = new NewProjectWizard();
        wizard.createNewProject(project, this.myWorkbenchFacade);
    }

    public GPOptionGroup getOptionGroup() {
        return this.myDocumentManager.getOptionGroup();
    }

    private GPUndoManager getUndoManager() {
        return this.myUndoManager;
    }

    private DocumentManager getDocumentManager() {
        return this.myDocumentManager;
    }

    private Document showURLDialog(IGanttProject project) {
        Document document = project.getDocument();
        GanttURLChooser uc = new GanttURLChooser(this.myWorkbenchFacade.getMainFrame(), false, null != document ? document.getURLPath() : null, null != document ? document.getUsername() : null, null != document ? document.getPassword() : null);
        uc.show();
        document = uc.change ? this.myDocumentManager.getDocument(uc.fileurl, uc.userName, uc.password) : null;
        return document;
    }
}

