/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.gui;

import javax.swing.table.AbstractTableModel;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.roles.Role;
import net.sourceforge.ganttproject.roles.RoleManager;

public class RolesTableModel
extends AbstractTableModel {
    final String[] columnNames = new String[]{GanttLanguage.getInstance().getText("id"), GanttLanguage.getInstance().getText("resourceRole")};
    final Object[][] data = new Object[100][];
    private RoleManager myRoleManager = RoleManager.Access.getInstance();

    public RolesTableModel() {
        Role[] roles = this.getRoleManager().getProjectLevelRoles();
        for (int i = 0; i < roles.length; ++i) {
            this.data[i] = new Object[]{String.valueOf(i), roles[i].getName()};
        }
        for (int j = i; j < this.data.length; ++j) {
            this.data[j] = new Object[2];
        }
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.data.length;
    }

    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public Object getValueAt(int row, int col) {
        return this.data[row][col];
    }

    public boolean isCellEditable(int row, int col) {
        return col == 1;
    }

    public void setValueAt(Object value, int row, int col) {
        this.data[row][col] = value;
        this.fireTableCellUpdated(row, col);
    }

    public RoleManager getRoleManager() {
        return this.myRoleManager;
    }

    public boolean hasChanges() {
        Role[] roles = this.getRoleManager().getProjectLevelRoles();
        for (int i = 0; i < this.getRowCount(); ++i) {
            String nextRoleName = (String)this.getValueAt(i, 1);
            if (nextRoleName == null) continue;
            if (i >= roles.length) {
                return true;
            }
            if (nextRoleName.equals(roles[i].getName())) continue;
            return true;
        }
        return false;
    }

    public void applyChanges() {
        this.getRoleManager().getProjectRoleSet().clear();
        for (int i = 0; i < this.getRowCount(); ++i) {
            String nextRoleName = (String)this.getValueAt(i, 1);
            if (nextRoleName == null) continue;
            this.getRoleManager().add(i, nextRoleName);
        }
    }
}

