/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import net.sourceforge.ganttproject.gui.TestGanttRolloverButton;
import net.sourceforge.ganttproject.language.GanttLanguage;

public class TextFieldAndFileChooserComponent {
    private TestGanttRolloverButton myChooserButton;
    private JTextField myTextField;
    private File myFile;
    private FileFilter myFileFilter;
    private String myDialogCaption;
    private Component myComponent;
    private Component myParentComponent;
    private int myFileSelectionMode = 2;

    public TextFieldAndFileChooserComponent(Component parentComponent, String dialogCaption) {
        this.myDialogCaption = dialogCaption;
        this.myParentComponent = parentComponent;
        this.initComponents();
    }

    public TextFieldAndFileChooserComponent(String label, String dialogCaption) {
        Box innerBox = Box.createHorizontalBox();
        innerBox.add(new JLabel(label));
        innerBox.add(Box.createHorizontalStrut(2));
        this.myParentComponent = innerBox;
        this.myDialogCaption = dialogCaption;
        this.initComponents();
        innerBox.add(this.myComponent);
        this.myComponent = innerBox;
    }

    private void initComponents() {
        this.myChooserButton = new TestGanttRolloverButton(new ImageIcon(this.getClass().getResource("/icons/open_16.gif")));
        this.myTextField = new JTextField();
        this.myTextField.setColumns(40);
        this.myTextField.setEditable(false);
        Box box = Box.createHorizontalBox();
        box.add(this.myTextField);
        box.add(this.myChooserButton);
        this.myComponent = box;
        this.myChooserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextFieldAndFileChooserComponent.this.showFileChooser();
            }
        });
    }

    public Component getComponent() {
        return this.myComponent;
    }

    public File getFile() {
        return this.myFile;
    }

    public void setFile(File file) {
        this.myFile = file;
        this.myTextField.setText(file == null ? "" : file.getAbsolutePath());
    }

    public void setFileFilter(FileFilter filter) {
        this.myFileFilter = filter;
    }

    public void showFileChooser() {
        System.out.println(this.myTextField.getText());
        JFileChooser fc = new JFileChooser(new File(this.myTextField.getText()));
        fc.setDialogTitle(this.myDialogCaption);
        fc.setApproveButtonToolTipText(this.myDialogCaption);
        fc.setFileSelectionMode(this.myFileSelectionMode);
        FileFilter[] filefilters = fc.getChoosableFileFilters();
        for (int i = 0; i < filefilters.length; ++i) {
            fc.removeChoosableFileFilter(filefilters[i]);
        }
        fc.addChoosableFileFilter(this.myFileFilter);
        int returnVal = fc.showDialog(this.myParentComponent, GanttLanguage.getInstance().getText("ok"));
        if (returnVal == 0) {
            this.onFileChosen(fc.getSelectedFile());
        }
    }

    protected void onFileChosen(File file) {
        this.myFile = file;
        this.myTextField.setText(this.myFile.getAbsolutePath());
    }

    public void setFileSelectionMode(int mode) {
        this.myFileSelectionMode = mode;
    }
}

