/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.gui;

import java.awt.Color;
import java.awt.Font;
import net.sourceforge.ganttproject.font.Fonts;
import net.sourceforge.ganttproject.gui.options.model.DefaultEnumerationOption;

public class UIConfiguration {
    private final Font myMenuFont;
    private final Font myChartMainFont;
    private Color myTaskColor;
    private Color myResColor;
    private Color myResOverColor;
    private Color myResUnderColor;
    private Color myEarlierPreviousTaskColor;
    private Color myLaterPreviousTaskColor;
    private Color myPreviousTaskColor;
    private Color myWeekEndColor;
    private Color myDayOffColor;
    private boolean isRedlineOn;
    private boolean isCriticalPathOn;
    private AlphaRenderingOption myWeekendAlphaRenderingOption;

    public UIConfiguration(Font menuFont, Font chartMainFont, Color taskColor, boolean isRedlineOn) {
        this.myMenuFont = menuFont == null ? Fonts.DEFAULT_MENU_FONT : menuFont;
        this.myChartMainFont = chartMainFont == null ? Fonts.DEFAULT_CHART_FONT : chartMainFont;
        this.isRedlineOn = isRedlineOn;
        this.setTaskColor(taskColor);
        this.myResColor = new Color(140, 182, 206);
        this.myResOverColor = new Color(229, 50, 50);
        this.myResUnderColor = new Color(50, 229, 50);
        this.myEarlierPreviousTaskColor = new Color(50, 229, 50);
        this.myLaterPreviousTaskColor = new Color(229, 50, 50);
        this.myPreviousTaskColor = Color.LIGHT_GRAY;
        this.myWeekEndColor = Color.GRAY;
        this.myDayOffColor = new Color(0.9f, 1.0f, 0.17f);
        this.myWeekendAlphaRenderingOption = new AlphaRenderingOption(this);
    }

    public Font getMenuFont() {
        return this.myMenuFont;
    }

    public Font getChartMainFont() {
        return this.myChartMainFont;
    }

    public Color getTaskColor() {
        return this.myTaskColor;
    }

    public void setTaskColor(Color myTaskColor) {
        this.myTaskColor = myTaskColor;
    }

    public Color getResourceColor() {
        return this.myResColor;
    }

    public void setResourceColor(Color myResColor) {
        this.myResColor = myResColor;
    }

    public Color getResourceOverloadColor() {
        return this.myResOverColor;
    }

    public void setResourceOverloadColor(Color myResOverColor) {
        this.myResOverColor = myResOverColor;
    }

    public Color getResourceUnderloadColor() {
        return this.myResUnderColor;
    }

    public void setResourceUnderloadColor(Color myResUnderColor) {
        this.myResUnderColor = myResUnderColor;
    }

    public Color getEarlierPreviousTaskColor() {
        return this.myEarlierPreviousTaskColor;
    }

    public void setEarlierPreviousTaskColor(Color earlierTaskColor) {
        this.myEarlierPreviousTaskColor = earlierTaskColor;
    }

    public Color getLaterPreviousTaskColor() {
        return this.myLaterPreviousTaskColor;
    }

    public void setLaterPreviousTaskColor(Color laterTaskColor) {
        this.myLaterPreviousTaskColor = laterTaskColor;
    }

    public Color getPreviousTaskColor() {
        return this.myPreviousTaskColor;
    }

    public void setPreviousTaskColor(Color previousTaskColor) {
        this.myPreviousTaskColor = previousTaskColor;
    }

    public Color getWeekEndColor() {
        return this.myWeekEndColor;
    }

    public Color getDayOffColor() {
        return this.myDayOffColor;
    }

    public void setWeekEndColor(Color myWeekEndColor) {
        this.myWeekEndColor = myWeekEndColor;
    }

    public void setDayOffColor(Color dayOffColor) {
        this.myDayOffColor = dayOffColor;
    }

    public boolean isRedlineOn() {
        return this.isRedlineOn;
    }

    public void setRedlineOn(boolean redlineOn) {
        this.isRedlineOn = redlineOn;
    }

    public boolean isCriticalPathOn() {
        return this.isCriticalPathOn;
    }

    public void setCriticalPathOn(boolean isOn) {
        this.isCriticalPathOn = isOn;
    }

    public AlphaRenderingOption getWeekendAlphaRenderingOption() {
        return this.myWeekendAlphaRenderingOption;
    }

    public static class AlphaRenderingOption
    extends DefaultEnumerationOption {
        static final String[] VALUES = new String[]{"chart.weekend_alpha_rendering.100", "chart.weekend_alpha_rendering.75", "chart.weekend_alpha_rendering.50", "chart.weekend_alpha_rendering.25", "chart.weekend_alpha_rendering.0"};
        final float[] FLOATS = new float[]{1.0f, 0.75f, 0.5f, 0.25f, 0.0f};
        private int myIndex = 0;

        AlphaRenderingOption(UIConfiguration config) {
            super("chart.weekend_alpha_rendering", VALUES);
        }

        public void commit() {
            super.commit();
            String value = this.getValue();
            for (int i = 0; i < VALUES.length; ++i) {
                if (!VALUES[i].equals(value)) continue;
                this.myIndex = i;
                break;
            }
        }

        public float getValueAsFloat() {
            return this.FLOATS[this.myIndex];
        }
    }
}

