/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.gui.options;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import net.sourceforge.ganttproject.gui.options.model.EnumerationOption;
import net.sourceforge.ganttproject.language.GanttLanguage;

class EnumerationOptionComboBoxModel
extends AbstractListModel
implements ComboBoxModel {
    private final List myValues;
    private Item mySelectedItem;
    private final EnumerationOption myOption;

    public EnumerationOptionComboBoxModel(EnumerationOption option) {
        this.myOption = option;
        String currentValue = option.getValue();
        Item currentItem = null;
        String[] ids = option.getAvailableValues();
        String[] i18nedValues = this.geti18nedValues(option);
        this.myValues = new ArrayList(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            Item nextItem = new Item(ids[i], i18nedValues[i]);
            this.myValues.add(nextItem);
            if (!ids[i].equals(currentValue)) continue;
            currentItem = nextItem;
        }
        if (currentItem != null) {
            this.setSelectedItem(currentItem);
        }
    }

    public void setSelectedItem(Object item) {
        this.mySelectedItem = (Item)item;
        this.myOption.setValue(this.mySelectedItem.myID);
    }

    public Object getSelectedItem() {
        return this.mySelectedItem;
    }

    public int getSize() {
        return this.myValues.size();
    }

    public Object getElementAt(int index) {
        return this.myValues.get(index);
    }

    String[] geti18nedValues(EnumerationOption option) {
        String[] ids = option.getAvailableValues();
        String[] result = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            result[i] = GanttLanguage.getInstance().getText("optionValue." + ids[i] + ".label");
            if (!result[i].startsWith("Missing Resource")) continue;
            result[i] = ids[i];
        }
        return result;
    }

    private static class Item {
        private final String myID;
        private final String myDisplayValue;

        public Item(String id, String displayValue) {
            this.myID = id;
            this.myDisplayValue = displayValue;
        }

        public String toString() {
            return this.myDisplayValue;
        }
    }
}

