/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.gui.options;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import net.sourceforge.ganttproject.GanttProject;
import net.sourceforge.ganttproject.document.HttpDocument;
import net.sourceforge.ganttproject.gui.options.GeneralOptionPanel;
import net.sourceforge.ganttproject.language.GanttLanguage;

public class ParametersSettingsPanel
extends GeneralOptionPanel {
    JCheckBox cbAutomatic;
    JSpinner spLockDAV;
    JTextField tfTaskPrefix;
    private GanttProject appli;

    public ParametersSettingsPanel(GanttProject parent) {
        super(GanttProject.correctLabel(GanttLanguage.getInstance().getText("parameters")), GanttLanguage.getInstance().getText("settingsParameters"), parent);
        this.appli = parent;
        JPanel autoPanel = new JPanel(new BorderLayout());
        this.cbAutomatic = new JCheckBox();
        autoPanel.add((Component)this.cbAutomatic, "West");
        autoPanel.add((Component)new JLabel(this.language.getText("automaticLaunch")), "Center");
        this.vb.add(autoPanel);
        this.vb.add(new JPanel());
        JPanel webDavPanel = new JPanel(new BorderLayout());
        this.spLockDAV = new JSpinner(new SpinnerNumberModel(240, 1, 1440, 1));
        webDavPanel.add((Component)this.spLockDAV, "West");
        webDavPanel.add((Component)new JLabel(this.language.getText("lockDAV")), "Center");
        this.vb.add(webDavPanel);
        this.vb.add(new JPanel());
        JPanel taskPrefixPanel = new JPanel(new BorderLayout());
        taskPrefixPanel.add((Component)new JLabel(this.language.getText("taskNamePrefix")), "West");
        this.tfTaskPrefix = new JTextField();
        taskPrefixPanel.add((Component)this.tfTaskPrefix, "Center");
        this.vb.add(taskPrefixPanel);
        this.vb.add(new JPanel());
        this.applyComponentOrientation(this.language.getComponentOrientation());
    }

    public boolean applyChanges(boolean askForApply) {
        if (this.getAutomatic() == this.appli.getOptions().getAutomatic() && this.getLockDAVMinutes() == this.appli.getOptions().getLockDAVMinutes() && (this.getTaskNamePrefix() == null || this.getTaskNamePrefix().equals(this.appli.getOptions().getTrueTaskNamePrefix()))) {
            this.bHasChange = false;
        } else {
            this.bHasChange = true;
            if (!askForApply || askForApply && this.askForApplyChanges()) {
                this.appli.getOptions().setAutomatic(this.getAutomatic());
                this.appli.getOptions().setTaskNamePrefix(this.getTaskNamePrefix());
                this.appli.getOptions().setLockDAVMinutes(this.getLockDAVMinutes());
                HttpDocument.setLockDAVMinutes(this.getLockDAVMinutes());
            }
        }
        return this.bHasChange;
    }

    public void initialize() {
        this.cbAutomatic.setSelected(this.appli.getOptions().getAutomatic());
        this.tfTaskPrefix.setText(this.appli.getOptions().getTaskNamePrefix());
        this.spLockDAV.setValue(new Integer(this.appli.getOptions().getLockDAVMinutes()));
    }

    public boolean getAutomatic() {
        return this.cbAutomatic.isSelected();
    }

    public int getLockDAVMinutes() {
        return (Integer)this.spLockDAV.getValue();
    }

    public String getTaskNamePrefix() {
        String res = this.tfTaskPrefix.getText();
        if (res.equals(this.language.getText("newTask"))) {
            return null;
        }
        return res;
    }
}

