/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.gui.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.sourceforge.ganttproject.GanttProject;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.gui.GanttDialogInfo;
import net.sourceforge.ganttproject.gui.TestGanttRolloverButton;
import net.sourceforge.ganttproject.gui.options.GeneralOptionPanel;
import net.sourceforge.ganttproject.language.GanttLanguage;
import net.sourceforge.ganttproject.util.BrowserControl;

public class ProjectSettingsPanel
extends GeneralOptionPanel {
    JTextField tfName;
    JTextField tfOrganization;
    JTextField tfWebLink;
    JTextArea taDescr;
    private final IGanttProject myProject;

    public ProjectSettingsPanel(Frame owner, IGanttProject project) {
        super(GanttProject.correctLabel(GanttLanguage.getInstance().getText("project")), GanttLanguage.getInstance().getText("settingsProject"), owner);
        this.myProject = project;
        Box vbproject = Box.createVerticalBox();
        JPanel namePanel = new JPanel(new BorderLayout());
        namePanel.add((Component)new JLabel(this.language.getText("name")), "West");
        vbproject.add(namePanel);
        this.tfName = new JTextField();
        vbproject.add(this.tfName);
        vbproject.add(new JPanel());
        JPanel orgaPanel = new JPanel(new BorderLayout());
        orgaPanel.add((Component)new JLabel(this.language.getText("organization")), "West");
        vbproject.add(orgaPanel);
        this.tfOrganization = new JTextField();
        vbproject.add(this.tfOrganization);
        vbproject.add(new JPanel());
        this.tfWebLink = new JTextField();
        TestGanttRolloverButton bWeb = new TestGanttRolloverButton(new ImageIcon(this.getClass().getResource("/icons/web_16.gif")));
        bWeb.setToolTipText(GanttProject.getToolTip(this.language.getText("openWebLink")));
        bWeb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!BrowserControl.displayURL(ProjectSettingsPanel.this.tfWebLink.getText())) {
                    GanttDialogInfo gdi = new GanttDialogInfo(null, 0, GanttDialogInfo.YES_OPTION, ProjectSettingsPanel.this.language.getText("msg4"), ProjectSettingsPanel.this.language.getText("error"));
                    gdi.show();
                }
            }
        });
        JPanel webPanel = new JPanel(new BorderLayout());
        webPanel.add((Component)new JLabel(this.language.getText("webLink")), "West");
        webPanel.add((Component)bWeb, "East");
        vbproject.add(webPanel);
        vbproject.add(this.tfWebLink);
        vbproject.add(new JPanel());
        JPanel descrPanel = new JPanel(new BorderLayout());
        descrPanel.add((Component)new JLabel(this.language.getText("shortDescription")), "West");
        vbproject.add(descrPanel);
        this.taDescr = new JTextArea(12, 25);
        this.taDescr.setLineWrap(true);
        this.taDescr.setWrapStyleWord(true);
        JScrollPane scpArea = new JScrollPane(this.taDescr);
        vbproject.add(scpArea);
        JPanel projectPanel = new JPanel(new BorderLayout());
        projectPanel.add((Component)vbproject, "North");
        this.vb.add(projectPanel);
        this.applyComponentOrientation(this.language.getComponentOrientation());
    }

    public boolean applyChanges(boolean askForApply) {
        if (this.myProject.getProjectName().equals(this.tfName.getText()) && this.myProject.getOrganization().equals(this.tfOrganization.getText()) && this.myProject.getWebLink().equals(this.tfWebLink.getText()) && this.myProject.getDescription().equals(this.taDescr.getText())) {
            this.bHasChange = false;
        } else {
            this.bHasChange = true;
            if (!askForApply || askForApply && this.askForApplyChanges()) {
                this.myProject.setProjectName(this.getProjectName());
                this.myProject.setDescription(this.getProjectDescription());
                this.myProject.setOrganization(this.getProjectOrganization());
                this.myProject.setWebLink(this.getWebLink());
            }
        }
        return this.bHasChange;
    }

    public void initialize() {
        this.tfName.setText(this.myProject.getProjectName());
        this.tfOrganization.setText(this.myProject.getOrganization());
        this.tfWebLink.setText(this.myProject.getWebLink());
        this.taDescr.setText(this.myProject.getDescription());
    }

    public String getProjectName() {
        return this.tfName.getText();
    }

    public String getProjectOrganization() {
        return this.tfOrganization.getText();
    }

    public String getWebLink() {
        return this.tfWebLink.getText();
    }

    public String getProjectDescription() {
        return this.taDescr.getText();
    }
}

