/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.gui.options.model;

import java.util.Date;
import net.sourceforge.ganttproject.gui.options.model.ChangeValueEvent;
import net.sourceforge.ganttproject.gui.options.model.DateOption;
import net.sourceforge.ganttproject.gui.options.model.GPAbstractOption;

public class DefaultDateOption
extends GPAbstractOption
implements DateOption {
    private Date myLockedValue;
    private Date myValue;

    public DefaultDateOption(String id) {
        super(id);
    }

    public void setValue(Date value) {
        if (!this.isLocked()) {
            throw new IllegalStateException("Lock option before setting value");
        }
        this.fireChangeValueEvent(new ChangeValueEvent(this.getID(), this.myLockedValue, value));
        this.myLockedValue = value;
    }

    public Date getValue() {
        return this.myValue;
    }

    public void commit() {
        super.commit();
        this.myValue = this.myLockedValue;
    }

    public boolean isChanged() {
        if (this.isLocked() && this.myValue != null) {
            return false == this.myValue.equals(this.myLockedValue);
        }
        return false;
    }

    public String getPersistentValue() {
        return null;
    }

    public void loadPersistentValue(String value) {
    }
}

