/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.gui.options.model;

import net.sourceforge.ganttproject.gui.options.model.ChangeValueEvent;
import net.sourceforge.ganttproject.gui.options.model.GPAbstractOption;
import net.sourceforge.ganttproject.gui.options.model.StringOption;

public class DefaultStringOption
extends GPAbstractOption
implements StringOption {
    private String myLockedValue;
    private String myValue;

    public DefaultStringOption(String id) {
        super(id);
    }

    public void setValue(String value) {
        if (!this.isLocked()) {
            throw new IllegalStateException("Lock option before setting value");
        }
        ChangeValueEvent event = new ChangeValueEvent(this.getID(), this.myLockedValue, value);
        this.myLockedValue = value;
        this.fireChangeValueEvent(event);
    }

    public String getValue() {
        return this.myValue;
    }

    public String getUncommitedValue() {
        return this.myLockedValue;
    }

    public void commit() {
        super.commit();
        this.myValue = this.myLockedValue;
    }

    public String getPersistentValue() {
        return this.getValue();
    }

    public void loadPersistentValue(String value) {
        this.setValue(value);
    }

    public boolean isChanged() {
        if (this.isLocked() && this.myValue != null) {
            return false == this.myValue.equals(this.myLockedValue);
        }
        return false;
    }
}

