/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.gui.previousState;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import net.sourceforge.ganttproject.GanttPreviousState;
import net.sourceforge.ganttproject.GanttProject;
import net.sourceforge.ganttproject.gui.DialogAligner;
import net.sourceforge.ganttproject.gui.GanttDialogInfo;
import net.sourceforge.ganttproject.gui.previousState.GanttSaveAsPreviousStateBean;
import net.sourceforge.ganttproject.language.GanttLanguage;

public class GanttDialogSaveAsPreviousState
extends JDialog
implements ActionListener {
    private GanttLanguage lang = GanttLanguage.getInstance();
    private GanttSaveAsPreviousStateBean previousStateBean;
    private GanttProject myProject;
    private boolean isSaved = false;
    private GanttPreviousState myPreviousState;

    public GanttDialogSaveAsPreviousState(GanttProject project) {
        super(project, GanttLanguage.getInstance().getText("saveCurrent"), true);
        this.myProject = project;
        this.previousStateBean = new GanttSaveAsPreviousStateBean(this.myProject);
        this.previousStateBean.addActionListener(this);
        Container cp = this.getContentPane();
        cp.add((Component)this.previousStateBean, "Center");
        this.pack();
        this.setResizable(false);
        DialogAligner.center(this, this.getParent());
        this.applyComponentOrientation(this.lang.getComponentOrientation());
    }

    public void actionPerformed(ActionEvent evt) {
        JComboBox comboBox;
        if (evt.getSource() instanceof JButton) {
            JButton button = (JButton)evt.getSource();
            if (button.getName().equals("ok")) {
                boolean overWrite = true;
                for (int i = 0; i < this.myProject.getPreviouStates().size(); ++i) {
                    if (!((GanttPreviousState)this.myProject.getPreviouStates().get(i)).getName().equals(this.previousStateBean.getName())) continue;
                    GanttDialogInfo gdi = new GanttDialogInfo(this.myProject, 1, GanttDialogInfo.YES_NO_OPTION, this.previousStateBean.getName() + "\n" + this.lang.getText("msg18"), this.lang.getText("warning"));
                    gdi.show();
                    if (gdi.res == 0) {
                        this.myProject.getPreviouStates().remove(i);
                        break;
                    }
                    overWrite = false;
                    break;
                }
                if (overWrite) {
                    try {
                        this.myPreviousState = new GanttPreviousState(this.previousStateBean.getName(), this.myProject);
                        this.isSaved = true;
                        this.previousStateBean.setDefaultName();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    this.setVisible(false);
                    this.dispose();
                }
            } else if (button.getName().equals("cancel")) {
                this.setVisible(false);
                this.dispose();
            }
        } else if (evt.getSource() instanceof JComboBox && (comboBox = (JComboBox)evt.getSource()).getName().equals("nameComboBox")) {
            this.previousStateBean.getTextField().setText(comboBox.getSelectedItem() + "");
        }
    }

    public boolean isSaved() {
        return this.isSaved;
    }

    public GanttPreviousState getPreviousState() {
        return this.myPreviousState;
    }
}

