/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.gui.projectwizard;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import net.sourceforge.ganttproject.action.CancelAction;
import net.sourceforge.ganttproject.action.OkAction;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.gui.options.TopPanel;
import net.sourceforge.ganttproject.gui.projectwizard.WizardPage;
import net.sourceforge.ganttproject.language.GanttLanguage;

public abstract class WizardImpl {
    private final ArrayList myPages = new ArrayList();
    private int myCurrentPage;
    private JPanel myPagesContainer;
    private CardLayout myCardLayout;
    private NextAction myNextAction;
    private BackAction myBackAction;
    private OkAction myOkAction;
    private UIFacade myUIFacade;
    private String myTitle;
    private CancelAction myCancelAction;

    public WizardImpl(UIFacade uiFacade, String title) {
        this.myUIFacade = uiFacade;
        this.myTitle = title;
        this.myCardLayout = new CardLayout();
        this.myPagesContainer = new JPanel(this.myCardLayout);
        this.myNextAction = new NextAction();
        this.myBackAction = new BackAction();
    }

    public void nextPage() {
        if (this.myCurrentPage < this.myPages.size() - 1) {
            this.getCurrentPage().setActive(false);
            ++this.myCurrentPage;
            this.getCurrentPage().setActive(true);
            this.myCardLayout.next(this.myPagesContainer);
        }
        this.adjustButtonState();
    }

    public void backPage() {
        if (this.myCurrentPage > 0) {
            this.getCurrentPage().setActive(false);
            --this.myCurrentPage;
            this.getCurrentPage().setActive(true);
            this.myCardLayout.previous(this.myPagesContainer);
        }
        this.adjustButtonState();
    }

    public void show() {
        for (int i = 0; i < this.myPages.size(); ++i) {
            WizardPage nextPage = (WizardPage)this.myPages.get(i);
            JPanel pagePanel = new JPanel(new BorderLayout());
            TopPanel titlePanel = new TopPanel(nextPage.getTitle() + "   (" + GanttLanguage.getInstance().getText("step") + " " + (i + 1) + " " + GanttLanguage.getInstance().getText("of") + " " + this.myPages.size() + ")", null);
            pagePanel.add((Component)titlePanel, "North");
            pagePanel.add(nextPage.getComponent());
            this.myPagesContainer.add((Component)pagePanel, nextPage.getTitle());
        }
        this.myCardLayout.first(this.myPagesContainer);
        this.myPagesContainer.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.myOkAction = new OkAction(){

            public void actionPerformed(ActionEvent e) {
                WizardImpl.this.onOkPressed();
            }
        };
        this.myCancelAction = new CancelAction(){

            public void actionPerformed(ActionEvent e) {
                WizardImpl.this.onCancelPressed();
            }
        };
        this.adjustButtonState();
        this.myUIFacade.showDialog(this.myPagesContainer, new Action[]{this.myBackAction, this.myNextAction, this.myOkAction, this.myCancelAction}, this.myTitle);
    }

    protected void adjustButtonState() {
        this.myBackAction.setEnabled(true);
        this.myNextAction.setEnabled(true);
        if (this.myCurrentPage == 0) {
            this.myBackAction.setEnabled(false);
        }
        if (this.myCurrentPage == this.myPages.size() - 1) {
            this.myNextAction.setEnabled(false);
        }
        this.myOkAction.setEnabled(this.canFinish());
    }

    protected boolean canFinish() {
        return true;
    }

    protected void addPage(WizardPage page) {
        this.myPages.add(page);
    }

    protected void onOkPressed() {
        this.getCurrentPage().setActive(false);
    }

    private void onCancelPressed() {
        this.getCurrentPage().setActive(false);
    }

    private WizardPage getCurrentPage() {
        return (WizardPage)this.myPages.get(this.myCurrentPage);
    }

    protected UIFacade getUIFacade() {
        return this.myUIFacade;
    }

    public class BackAction
    extends AbstractAction {
        BackAction() {
            super(GanttLanguage.getInstance().getText("back"));
        }

        public void actionPerformed(ActionEvent e) {
            WizardImpl.this.backPage();
        }
    }

    public class NextAction
    extends AbstractAction {
        NextAction() {
            super(GanttLanguage.getInstance().getText("next"));
        }

        public void actionPerformed(ActionEvent e) {
            WizardImpl.this.nextPage();
        }
    }
}

