/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.importer;

import java.io.File;
import java.util.ArrayList;
import net.sourceforge.ganttproject.GanttProject;
import net.sourceforge.ganttproject.Mediator;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.gui.projectwizard.WizardImpl;
import net.sourceforge.ganttproject.importer.FileChooserPage;
import net.sourceforge.ganttproject.importer.Importer;
import net.sourceforge.ganttproject.importer.ImporterChooserPage;
import net.sourceforge.ganttproject.language.GanttLanguage;

public class ImportFileWizardImpl
extends WizardImpl {
    private State myState;
    private GanttProject myProject;

    public ImportFileWizardImpl(UIFacade uiFacade, GanttProject project) {
        super(uiFacade, GanttLanguage.getInstance().getText("importWizard.dialog.title"));
        this.myProject = project;
        this.myState = new State();
        Importer[] importers = this.getImporters();
        this.addPage(new ImporterChooserPage(importers, this.myState));
        this.addPage(new FileChooserPage(this.myState));
    }

    private Importer[] getImporters() {
        ArrayList result = new ArrayList();
        Importer[] importers = (Importer[])Mediator.getPluginManager().getExtensions("net.sourceforge.ganttproject.importer", Importer.class);
        return importers;
    }

    protected void onOkPressed() {
        super.onOkPressed();
        this.myState.myImporter.run(this.myProject, this.myProject.getUIFacade(), this.myState.getFile());
    }

    protected boolean canFinish() {
        return this.myState.myImporter != null && this.myState.getFile() != null;
    }

    class State {
        Importer myImporter;
        private File myFile;

        State() {
        }

        void setFile(File myFile) {
            this.myFile = myFile;
            ImportFileWizardImpl.this.adjustButtonState();
        }

        File getFile() {
            return this.myFile;
        }
    }
}

