/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.importer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import net.sourceforge.ganttproject.gui.options.GPOptionChoicePanel;
import net.sourceforge.ganttproject.gui.options.model.GPOptionGroup;
import net.sourceforge.ganttproject.gui.projectwizard.WizardPage;
import net.sourceforge.ganttproject.importer.ImportFileWizardImpl;
import net.sourceforge.ganttproject.importer.Importer;
import net.sourceforge.ganttproject.language.GanttLanguage;

class ImporterChooserPage
implements WizardPage {
    private Importer[] myImporters;
    private ImportFileWizardImpl.State myState;

    ImporterChooserPage(Importer[] importers, ImportFileWizardImpl.State state) {
        this.myImporters = importers;
        this.myState = state;
    }

    public String getTitle() {
        return GanttLanguage.getInstance().getText("importerChooserPageTitle");
    }

    public Component getComponent() {
        Action[] choiceChangeActions = new Action[this.myImporters.length];
        GPOptionGroup[] choiceOptions = new GPOptionGroup[this.myImporters.length];
        for (int i = 0; i < this.myImporters.length; ++i) {
            final Importer nextImporter = this.myImporters[i];
            AbstractAction nextAction = new AbstractAction(nextImporter.getFileTypeDescription()){

                public void actionPerformed(ActionEvent e) {
                    ((ImporterChooserPage)ImporterChooserPage.this).myState.myImporter = nextImporter;
                }
            };
            choiceChangeActions[i] = nextAction;
            choiceOptions[i] = null;
            if (i != 0) continue;
            this.myState.myImporter = nextImporter;
        }
        GPOptionChoicePanel panel = new GPOptionChoicePanel();
        return panel.getComponent(choiceChangeActions, choiceOptions, 0);
    }

    public void setActive(boolean b) {
    }
}

