/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.ganttproject.GanttCalendar;
import net.sourceforge.ganttproject.GanttGraphicArea;
import net.sourceforge.ganttproject.GanttProject;
import net.sourceforge.ganttproject.GanttResourcePanel;
import net.sourceforge.ganttproject.GanttTree2;
import net.sourceforge.ganttproject.IGanttProject;
import net.sourceforge.ganttproject.Mediator;
import net.sourceforge.ganttproject.gui.UIFacade;
import net.sourceforge.ganttproject.io.AssignmentSaver;
import net.sourceforge.ganttproject.io.CalendarSaver;
import net.sourceforge.ganttproject.io.GPSaver;
import net.sourceforge.ganttproject.io.GanttChartViewSaver;
import net.sourceforge.ganttproject.io.HistorySaver;
import net.sourceforge.ganttproject.io.ResourceSaver;
import net.sourceforge.ganttproject.io.SaverBase;
import net.sourceforge.ganttproject.io.TaskSaver;
import net.sourceforge.ganttproject.io.VacationSaver;
import net.sourceforge.ganttproject.io.ViewSaver;
import net.sourceforge.ganttproject.roles.Role;
import net.sourceforge.ganttproject.roles.RoleManager;
import net.sourceforge.ganttproject.roles.RoleSet;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class GanttXMLSaver
extends SaverBase
implements GPSaver {
    private static final String VERSION = "2.0";
    private final IGanttProject myProject;
    private final UIFacade myUIFacade;
    private GanttTree2 tree;
    private GanttGraphicArea area;

    public GanttXMLSaver(IGanttProject project, GanttTree2 tree, GanttResourcePanel peop, GanttGraphicArea area, UIFacade uiFacade) {
        this.tree = tree;
        this.area = area;
        this.myProject = project;
        this.myUIFacade = uiFacade;
    }

    public void save(OutputStream stream) throws IOException {
        try {
            AttributesImpl attrs = new AttributesImpl();
            StreamResult result = new StreamResult(stream);
            SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            TransformerHandler handler = factory.newTransformerHandler();
            Transformer serializer = handler.getTransformer();
            serializer.setOutputProperty("encoding", "UTF-8");
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("method", "xml");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            handler.setResult(result);
            handler.startDocument();
            this.addAttribute("name", this.getProject().getProjectName(), attrs);
            this.addAttribute("company", this.getProject().getOrganization(), attrs);
            this.addAttribute("webLink", this.getProject().getWebLink(), attrs);
            this.addAttribute("view-date", new GanttCalendar(this.area.getViewState().getStartDate()).toXMLString(), attrs);
            this.addAttribute("view-index", "" + this.myUIFacade.getViewIndex(), attrs);
            this.addAttribute("gantt-divider-location", "" + this.myUIFacade.getGanttDividerLocation(), attrs);
            this.addAttribute("resource-divider-location", "" + this.myUIFacade.getResourceDividerLocation(), attrs);
            this.addAttribute("version", VERSION, attrs);
            this.startElement("project", attrs, handler);
            this.cdataElement("description", this.getProject().getDescription(), attrs, handler);
            this.saveViews(handler);
            this.emptyComment(handler);
            this.saveCalendar(handler);
            this.saveTasks(handler);
            this.saveResources(handler);
            this.saveAssignments(handler);
            this.saveVacations(handler);
            this.saveGanttChartView(handler);
            this.saveHistory(handler);
            this.saveRoles(handler);
            this.endElement("project", handler);
            handler.endDocument();
            stream.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
            IOException propagatedException = new IOException("Failed to save the project file");
            propagatedException.initCause(e);
            throw propagatedException;
        }
    }

    private void saveHistory(TransformerHandler handler) throws SAXException, ParserConfigurationException, IOException {
        ArrayList history = ((GanttProject)this.myProject).getPreviouStates();
        new HistorySaver().save(history, handler);
    }

    private void saveGanttChartView(TransformerHandler handler) throws SAXException {
        new GanttChartViewSaver().save(this.tree.getTreeTable(), handler);
    }

    private void saveVacations(TransformerHandler handler) throws SAXException {
        new VacationSaver().save(this.getProject(), handler);
    }

    private void saveResources(TransformerHandler handler) throws SAXException {
        new ResourceSaver().save(this.getProject(), handler);
    }

    private void saveViews(TransformerHandler handler) throws SAXException {
        new ViewSaver().save(this.getUIFacade(), handler);
    }

    private void saveCalendar(TransformerHandler handler) throws SAXException {
        new CalendarSaver().save(this.getProject(), handler);
    }

    private void saveTasks(TransformerHandler handler) throws SAXException, IOException {
        new TaskSaver().save(this.getProject(), handler, this.area.getTaskColor(), Mediator.getCustomColumnsStorage());
    }

    private void saveAssignments(TransformerHandler handler) throws SAXException {
        new AssignmentSaver().save(this.getProject(), handler);
    }

    private void saveRoles(TransformerHandler handler) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        RoleManager roleManager = this.getProject().getRoleManager();
        RoleSet[] roleSets = roleManager.getRoleSets();
        for (int i = 0; i < roleSets.length; ++i) {
            RoleSet next = roleSets[i];
            if (!next.isEnabled()) continue;
            this.addAttribute("roleset-name", next.getName(), attrs);
            this.emptyElement("roles", attrs, handler);
        }
        RoleSet projectRoleSet = roleManager.getProjectRoleSet();
        if (!projectRoleSet.isEmpty()) {
            this.startElement("roles", attrs, handler);
            Role[] projectRoles = projectRoleSet.getRoles();
            for (int i = 0; i < projectRoles.length; ++i) {
                Role next = projectRoles[i];
                this.addAttribute("id", next.getPersistentID(), attrs);
                this.addAttribute("name", next.getName(), attrs);
                this.emptyElement("role", attrs, handler);
            }
            this.endElement("roles", handler);
        }
    }

    IGanttProject getProject() {
        return this.myProject;
    }

    UIFacade getUIFacade() {
        return this.myUIFacade;
    }
}

