/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ganttproject.parser;

import net.sourceforge.ganttproject.GanttCalendar;
import net.sourceforge.ganttproject.calendar.GanttDaysOff;
import net.sourceforge.ganttproject.parser.ParsingListener;
import net.sourceforge.ganttproject.parser.TagHandler;
import net.sourceforge.ganttproject.resource.HumanResource;
import net.sourceforge.ganttproject.resource.HumanResourceManager;
import net.sourceforge.ganttproject.resource.ResourceManager;
import org.xml.sax.Attributes;

public class VacationTagHandler
implements TagHandler,
ParsingListener {
    private ResourceManager myResourceManager;

    public VacationTagHandler(ResourceManager resourceManager) {
        this.myResourceManager = (HumanResourceManager)resourceManager;
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) {
        if (qName.equals("vacation")) {
            this.loadResource(attrs);
        }
    }

    private void loadResource(Attributes atts) {
        try {
            String startAsString = atts.getValue("start");
            String endAsString = atts.getValue("end");
            String resourceIdAsString = atts.getValue("resourceid");
            HumanResource hr = (HumanResource)this.myResourceManager.getById(Integer.parseInt(resourceIdAsString));
            hr.addDaysOff(new GanttDaysOff(GanttCalendar.parseXMLDate(startAsString), GanttCalendar.parseXMLDate(endAsString)));
        }
        catch (NumberFormatException e) {
            System.out.println("ERROR in parsing XML File year is not numeric: " + e.toString());
            return;
        }
    }

    public void endElement(String namespaceURI, String sName, String qName) {
    }

    public void parsingStarted() {
    }

    public void parsingFinished() {
    }
}

